/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.player;

import io.redspace.ironsspellbooks.capabilities.spell.SpellData;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.Utils;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class CommonPlayerEvents {
    public static void onPlayerRightClickItem(PlayerInteractEvent.RightClickItem event) {
        ItemStack stack = event.getItemStack();
        if (Utils.canImbue(stack)) {
            SpellData spellData = SpellData.getSpellData(stack);
            InteractionResultHolder<ItemStack> result = Utils.onUseCastingHelper(event.getWorld(), event.getPlayer(), event.getHand(), stack, spellData.getSpell());
            if (result != null) {
                event.setCancellationResult(result.m_19089_());
                event.setCanceled(true);
            }
        }
    }

    public static void onUseItemStop(LivingEntityUseItemEvent.Stop event) {
        ItemStack stack = event.getItem();
        if (Utils.canImbue(stack)) {
            AbstractSpell spell = SpellData.getSpellData(stack).getSpell();
            LivingEntity entity = event.getEntityLiving();
            if (spell.getSpellType() != SpellType.NONE_SPELL) {
                entity.m_5810_();
                Utils.releaseUsingHelper(entity);
            }
        }
    }
}

