/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.player;

import io.redspace.ironsspellbooks.capabilities.magic.SyncedSpellData;
import io.redspace.ironsspellbooks.capabilities.spell.SpellData;
import io.redspace.ironsspellbooks.effect.AbyssalShroudEffect;
import io.redspace.ironsspellbooks.effect.AscensionEffect;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.item.Scroll;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import io.redspace.ironsspellbooks.render.SpellRenderingHelper;
import io.redspace.ironsspellbooks.spells.CastSource;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.spells.blood.RayOfSiphoningSpell;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import io.redspace.ironsspellbooks.util.TooltipsUtils;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientPlayerEvents {
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side.isClient() && event.phase == TickEvent.Phase.END && event.player == Minecraft.m_91087_().f_91074_) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            ClientMagicData.getCooldowns().tick(1);
            if (ClientMagicData.getCastDuration() > 0) {
                ClientMagicData.handleCastDuration();
            }
            if (level != null) {
                List spellcasters = level.m_6249_((Entity)null, event.player.m_142469_().m_82400_(64.0), mob -> mob instanceof Player || mob instanceof AbstractSpellCastingMob);
                spellcasters.forEach(entity -> {
                    SpellType currentSpell;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    SyncedSpellData spellData = ClientMagicData.getSyncedSpellData(livingEntity);
                    if (spellData.hasEffect(8L)) {
                        AbyssalShroudEffect.ambientParticles(level, livingEntity);
                    }
                    if (spellData.hasEffect(16L)) {
                        AscensionEffect.ambientParticles(level, livingEntity);
                    }
                    if ((currentSpell = SpellType.getTypeFromValue(spellData.getCastingSpellId())) == SpellType.RAY_OF_SIPHONING_SPELL) {
                        Vec3 impact = Utils.raycastForEntity(entity.f_19853_, entity, RayOfSiphoningSpell.getRange(0), true).m_82450_().m_82492_(0.0, 0.25, 0.0);
                        for (int i = 0; i < 8; ++i) {
                            Vec3 motion = new Vec3(Utils.getRandomScaled(0.2f), Utils.getRandomScaled(0.2f), Utils.getRandomScaled(0.2f));
                            entity.f_19853_.m_7106_(ParticleHelper.SIPHON, impact.f_82479_ + motion.f_82479_, impact.f_82480_ + motion.f_82480_, impact.f_82481_ + motion.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
                        }
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void beforeLivingRender(RenderLivingEvent.Pre<? extends LivingEntity, ? extends EntityModel<? extends LivingEntity>> event) {
        SyncedSpellData syncedData;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if ((livingEntity instanceof Player || livingEntity instanceof AbstractSpellCastingMob) && (syncedData = ClientMagicData.getSyncedSpellData(livingEntity)).hasEffect(32L) && livingEntity.m_20177_((Player)player)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void afterLivingRender(RenderLivingEvent.Post<? extends LivingEntity, ? extends EntityModel<? extends LivingEntity>> event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            SyncedSpellData syncedData = ClientMagicData.getSyncedSpellData(livingEntity);
            SpellRenderingHelper.renderSpellHelper(syncedData, livingEntity, event.getPoseStack(), event.getMultiBufferSource(), event.getPartialTick());
        }
    }

    @SubscribeEvent
    public static void imbuedWeaponTooltips(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (SpellData.hasSpellData(stack)) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            if (!(stack.m_41720_() instanceof Scroll)) {
                List<Component> additionalLines = TooltipsUtils.formatActiveSpellTooltip(stack, CastSource.SWORD);
                additionalLines.add(1, (Component)io.redspace.ironsspellbooks.util.Component.translatable("tooltip.irons_spellbooks.imbued_tooltip", new Object[0]).m_130940_(ChatFormatting.GRAY));
                additionalLines.set(2, (Component)io.redspace.ironsspellbooks.util.Component.literal(" ").m_7220_(additionalLines.get(2)));
                if (event.getFlags().m_7050_()) {
                    event.getToolTip().addAll(event.getToolTip().size() - 2, additionalLines);
                } else {
                    event.getToolTip().addAll(additionalLines);
                }
            }
        }
    }
}

