/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.player;

import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.capabilities.magic.ClientSpellTargetingData;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerCooldowns;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.capabilities.magic.SyncedSpellData;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.spells.CastSource;
import io.redspace.ironsspellbooks.spells.CastType;
import io.redspace.ironsspellbooks.spells.SpellType;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class ClientMagicData {
    private static final PlayerMagicData playerMagicData = new PlayerMagicData();
    private static final HashMap<Integer, SyncedSpellData> playerSyncedDataLookup = new HashMap();
    private static final SyncedSpellData emptySyncedData = new SyncedSpellData(-999);
    private static ClientSpellTargetingData spellTargetingData;
    public static HashMap<UUID, KeyframeAnimationPlayer> castingAnimationPlayerLookup;

    public static void setTargetingData(ClientSpellTargetingData spellTargetingData) {
        ClientMagicData.spellTargetingData = spellTargetingData;
    }

    public static ClientSpellTargetingData getTargetingData() {
        if (spellTargetingData == null) {
            ClientMagicData.setTargetingData(new ClientSpellTargetingData());
        }
        return spellTargetingData;
    }

    public static void resetTargetingData() {
        spellTargetingData = null;
    }

    public static PlayerCooldowns getCooldowns() {
        return playerMagicData.getPlayerCooldowns();
    }

    public static float getCooldownPercent(SpellType spellType) {
        return playerMagicData.getPlayerCooldowns().getCooldownPercent(spellType);
    }

    public static int getPlayerMana() {
        return playerMagicData.getMana();
    }

    public static void setMana(int playerMana) {
        playerMagicData.setMana(playerMana);
    }

    public static CastType getCastType() {
        return playerMagicData.getCastType();
    }

    public static int getCastingSpellId() {
        return playerMagicData.getCastingSpellId();
    }

    public static int getCastDurationRemaining() {
        return playerMagicData.getCastDurationRemaining();
    }

    public static int getCastDuration() {
        return playerMagicData.getCastDuration();
    }

    public static boolean isCasting() {
        return playerMagicData.isCasting();
    }

    public static void handleCastDuration() {
        playerMagicData.handleCastDuration();
    }

    public static float getCastCompletionPercent() {
        return playerMagicData.getCastCompletionPercent();
    }

    public static void setClientCastState(int spellId, int spellLevel, int castDuration, CastSource castSource) {
        playerMagicData.initiateCast(spellId, spellLevel, castDuration, castSource);
    }

    public static void resetClientCastState(UUID playerUUID) {
        KeyframeAnimationPlayer animationPlayer;
        if (Minecraft.m_91087_().f_91074_.m_142081_().equals(playerUUID)) {
            playerMagicData.resetCastingState();
            ClientMagicData.resetTargetingData();
        }
        if ((animationPlayer = (KeyframeAnimationPlayer)castingAnimationPlayerLookup.getOrDefault(playerUUID, null)) != null) {
            animationPlayer.stop();
        }
        if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_6117_() && Minecraft.m_91087_().f_91074_.m_142081_().equals(playerUUID)) {
            Minecraft.m_91087_().f_91074_.m_5810_();
        }
    }

    public static SyncedSpellData getSyncedSpellData(LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            return playerSyncedDataLookup.getOrDefault(livingEntity.m_142049_(), emptySyncedData);
        }
        if (livingEntity instanceof AbstractSpellCastingMob) {
            AbstractSpellCastingMob abstractSpellCastingMob = (AbstractSpellCastingMob)livingEntity;
            return abstractSpellCastingMob.getPlayerMagicData().getSyncedData();
        }
        return new SyncedSpellData(null);
    }

    public static void handlePlayerSyncedData(SyncedSpellData playerSyncedData) {
        playerSyncedDataLookup.put(playerSyncedData.getServerPlayerId(), playerSyncedData);
    }

    public static void handleAbstractCastingMobSyncedData(int entityId, SyncedSpellData syncedSpellData) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        IronsSpellbooks.LOGGER.debug("handleAbstractCastingMobSyncedData {}, {}, {}", new Object[]{level, entityId, syncedSpellData});
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(entityId);
        if (entity instanceof AbstractSpellCastingMob) {
            AbstractSpellCastingMob abstractSpellCastingMob = (AbstractSpellCastingMob)entity;
            abstractSpellCastingMob.setSyncedSpellData(syncedSpellData);
        }
    }

    static {
        castingAnimationPlayerLookup = new HashMap();
    }
}

