/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.network.spell;

import io.redspace.ironsspellbooks.capabilities.magic.ClientSpellTargetingData;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import io.redspace.ironsspellbooks.spells.SpellType;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundSyncTargetingData {
    private final UUID targetUUID;
    private final int spellId;

    public ClientboundSyncTargetingData(LivingEntity entity, SpellType spellType) {
        this.targetUUID = entity.m_142081_();
        this.spellId = spellType.getValue();
    }

    public ClientboundSyncTargetingData(FriendlyByteBuf buf) {
        this.targetUUID = buf.m_130259_();
        this.spellId = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.targetUUID);
        buf.writeInt(this.spellId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> ClientMagicData.setTargetingData(new ClientSpellTargetingData(this.targetUUID, this.spellId)));
        return true;
    }
}

