/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.network.spell;

import io.redspace.ironsspellbooks.capabilities.magic.CastData;
import io.redspace.ironsspellbooks.capabilities.magic.CastDataSerializable;
import io.redspace.ironsspellbooks.player.ClientSpellCastHelper;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.CastSource;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundOnClientCast {
    int spellId;
    int level;
    CastSource castSource;
    CastData castData;

    public ClientboundOnClientCast(int spellId, int level, CastSource castSource, CastData castData) {
        this.spellId = spellId;
        this.level = level;
        this.castSource = castSource;
        this.castData = castData;
    }

    public ClientboundOnClientCast(FriendlyByteBuf buf) {
        this.spellId = buf.readInt();
        this.level = buf.readInt();
        this.castSource = (CastSource)buf.m_130066_(CastSource.class);
        if (buf.readBoolean()) {
            CastDataSerializable tmp = AbstractSpell.getSpell(this.spellId, this.level).getEmptyCastData();
            tmp.readFromStream(buf);
            this.castData = tmp;
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.spellId);
        buf.writeInt(this.level);
        buf.m_130068_((Enum)this.castSource);
        CastData castData = this.castData;
        if (castData instanceof CastDataSerializable) {
            CastDataSerializable castDataSerializable = (CastDataSerializable)castData;
            buf.writeBoolean(true);
            castDataSerializable.writeToStream(buf);
        } else {
            buf.writeBoolean(false);
        }
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientSpellCastHelper.handleClientboundOnClientCast(this.spellId, this.level, this.castSource, this.castData)));
        return true;
    }
}

