/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.network.spell;

import io.redspace.ironsspellbooks.player.ClientSpellCastHelper;
import io.redspace.ironsspellbooks.spells.SpellType;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundOnCastFinished {
    private final SpellType spellType;
    private final UUID castingEntityId;
    private final boolean cancelled;

    public ClientboundOnCastFinished(UUID castingEntityId, SpellType spellType, boolean cancelled) {
        this.spellType = spellType;
        this.castingEntityId = castingEntityId;
        this.cancelled = cancelled;
    }

    public ClientboundOnCastFinished(FriendlyByteBuf buf) {
        this.spellType = (SpellType)buf.m_130066_(SpellType.class);
        this.castingEntityId = buf.m_130259_();
        this.cancelled = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.spellType);
        buf.m_130077_(this.castingEntityId);
        buf.writeBoolean(this.cancelled);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> ClientSpellCastHelper.handleClientBoundOnCastFinished(this.castingEntityId, this.spellType, this.cancelled));
        return true;
    }
}

