/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.network;

import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.capabilities.spellbook.SpellBookData;
import io.redspace.ironsspellbooks.network.ServerboundCancelCast;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.CastSource;
import io.redspace.ironsspellbooks.spells.CastType;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundQuickCast {
    private int slot;
    private InteractionHand hand;

    public ServerboundQuickCast(int slot, InteractionHand hand) {
        this.slot = slot;
        this.hand = hand;
    }

    public ServerboundQuickCast(FriendlyByteBuf buf) {
        this.slot = buf.readInt();
        this.hand = (InteractionHand)buf.m_130066_(InteractionHand.class);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.slot);
        buf.m_130068_((Enum)this.hand);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            AbstractSpell spell;
            ServerPlayer serverPlayer = ctx.getSender();
            ItemStack itemStack = serverPlayer.m_21120_(this.hand);
            SpellBookData sbd = SpellBookData.getSpellBookData(itemStack);
            if (sbd.getSpellSlots() > 0 && this.slot < sbd.getSpellSlots() && (spell = sbd.getSpell(this.slot)) != null) {
                PlayerMagicData playerMagicData = PlayerMagicData.getPlayerMagicData((LivingEntity)serverPlayer);
                if (playerMagicData.isCasting() && playerMagicData.getCastingSpellId() != spell.getID()) {
                    ServerboundCancelCast.cancelCast(serverPlayer, playerMagicData.getCastType() != CastType.LONG);
                }
                spell.attemptInitiateCast(itemStack, serverPlayer.f_19853_, (Player)serverPlayer, CastSource.SPELLBOOK, true);
            }
        });
        return true;
    }
}

