/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.network;

import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.item.Scroll;
import io.redspace.ironsspellbooks.spells.CastType;
import io.redspace.ironsspellbooks.spells.SpellType;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundCancelCast {
    private final boolean triggerCooldown;

    public ServerboundCancelCast(boolean triggerCooldown) {
        this.triggerCooldown = triggerCooldown;
    }

    public ServerboundCancelCast(FriendlyByteBuf buf) {
        this.triggerCooldown = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.triggerCooldown);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer serverPlayer = ctx.getSender();
            ServerboundCancelCast.cancelCast(serverPlayer, this.triggerCooldown);
        });
        return true;
    }

    public static void cancelCast(ServerPlayer serverPlayer, boolean triggerCooldown) {
        PlayerMagicData playerMagicData;
        if (serverPlayer != null && (playerMagicData = PlayerMagicData.getPlayerMagicData((LivingEntity)serverPlayer)).isCasting()) {
            int spellId = playerMagicData.getCastingSpellId();
            if (triggerCooldown) {
                MagicManager.get(serverPlayer.f_19853_).addCooldown(serverPlayer, SpellType.values()[spellId], playerMagicData.getCastSource());
            }
            playerMagicData.getCastingSpell().onServerCastComplete(serverPlayer.f_19853_, (LivingEntity)serverPlayer, playerMagicData, true);
            if (SpellType.values()[spellId].getCastType() == CastType.CONTINUOUS) {
                Scroll.attemptRemoveScrollAfterCast(serverPlayer);
            }
        }
    }
}

