/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.network;

import io.redspace.ironsspellbooks.capabilities.magic.CooldownInstance;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import io.redspace.ironsspellbooks.spells.SpellType;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundSyncCooldowns {
    private final Map<SpellType, CooldownInstance> spellCooldowns;

    public static SpellType readSpellType(FriendlyByteBuf buffer) {
        return SpellType.getTypeFromValue(buffer.readInt());
    }

    public static CooldownInstance readCoolDownInstance(FriendlyByteBuf buffer) {
        int spellCooldown = buffer.readInt();
        int spellCooldownRemaining = buffer.readInt();
        return new CooldownInstance(spellCooldown, spellCooldownRemaining);
    }

    public static void writeSpellType(FriendlyByteBuf buf, SpellType spellType) {
        buf.writeInt(spellType.getValue());
    }

    public static void writeCoolDownInstance(FriendlyByteBuf buf, CooldownInstance cooldownInstance) {
        buf.writeInt(cooldownInstance.getSpellCooldown());
        buf.writeInt(cooldownInstance.getCooldownRemaining());
    }

    public ClientboundSyncCooldowns(Map<SpellType, CooldownInstance> spellCooldowns) {
        this.spellCooldowns = spellCooldowns;
    }

    public ClientboundSyncCooldowns(FriendlyByteBuf buf) {
        this.spellCooldowns = buf.m_178368_(ClientboundSyncCooldowns::readSpellType, ClientboundSyncCooldowns::readCoolDownInstance);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_178355_(this.spellCooldowns, ClientboundSyncCooldowns::writeSpellType, ClientboundSyncCooldowns::writeCoolDownInstance);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            this.spellCooldowns.forEach((k, v) -> ClientMagicData.getCooldowns().addCooldown((SpellType)((Object)((Object)k)), v.getSpellCooldown(), v.getCooldownRemaining()));
            ClientMagicData.resetClientCastState(null);
        });
        return true;
    }
}

