/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.network;

import io.redspace.ironsspellbooks.player.ClientMagicData;
import io.redspace.ironsspellbooks.spells.SpellType;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundSyncCooldown {
    private final int spellId;
    private final int duration;

    public ClientboundSyncCooldown(int spellId, int duration) {
        this.spellId = spellId;
        this.duration = duration;
    }

    public ClientboundSyncCooldown(FriendlyByteBuf buf) {
        this.spellId = buf.readInt();
        this.duration = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.spellId);
        buf.writeInt(this.duration);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> ClientMagicData.getCooldowns().addCooldown(SpellType.values()[this.spellId], this.duration));
        return true;
    }
}

