/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.mixin;

import com.mojang.authlib.GameProfile;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AdjustmentModifier;
import dev.kosmx.playerAnim.api.layered.modifier.MirrorModifier;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import io.redspace.ironsspellbooks.item.armor.ArmorCapeProvider;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import java.util.Optional;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractClientPlayer.class})
public class AbstractClientPlayerMixin {
    @Inject(method={"getCloakTextureLocation"}, at={@At(value="HEAD")}, cancellable=true)
    public void getCloakTextureLocation(CallbackInfoReturnable<ResourceLocation> cir) {
        Player player = (Player)this;
        ItemStack itemstack = player.m_6844_(EquipmentSlot.CHEST);
        Item item = itemstack.m_41720_();
        if (item instanceof ArmorCapeProvider) {
            ArmorCapeProvider capeProvider = (ArmorCapeProvider)item;
            if (!player.m_21023_((MobEffect)MobEffectRegistry.ANGEL_WINGS.get())) {
                cir.setReturnValue((Object)capeProvider.getCapeResourceLocation());
            }
        }
    }

    @Inject(method={"isCapeLoaded"}, at={@At(value="HEAD")}, cancellable=true)
    public void isCapeLoaded(CallbackInfoReturnable<Boolean> cir) {
        Player player = (Player)this;
        ItemStack itemstack = player.m_6844_(EquipmentSlot.CHEST);
        Item item = itemstack.m_41720_();
        if (item instanceof ArmorCapeProvider) {
            ArmorCapeProvider capeProvider = (ArmorCapeProvider)item;
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void postInit(ClientLevel pClientLevel, GameProfile pGameProfile, CallbackInfo ci) {
        final Player player = (Player)this;
        ModifierLayer animation = (ModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)((AbstractClientPlayer)player)).get(AbstractSpell.ANIMATION_RESOURCE);
        if (animation != null) {
            animation.addModifierLast((AbstractModifier)new AdjustmentModifier(partName -> {
                float rotationX = 0.0f;
                float rotationY = 0.0f;
                float rotationZ = 0.0f;
                float offsetX = 0.0f;
                float offsetY = 0.0f;
                float offsetZ = 0.0f;
                float pitch = player.m_146909_();
                float yaw = player.f_20885_ - player.f_20883_;
                pitch = (float)Math.toRadians(pitch);
                yaw = (float)Math.toRadians(yaw);
                switch (partName) {
                    case "rightArm": 
                    case "leftArm": {
                        rotationX = pitch;
                        rotationY = yaw;
                        break;
                    }
                    default: {
                        return Optional.empty();
                    }
                }
                return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(rotationX, rotationY, rotationZ), new Vec3f(offsetX, offsetY, offsetZ)));
            }));
            animation.addModifierLast((AbstractModifier)new MirrorModifier(){

                public boolean isEnabled() {
                    return player.m_7655_() == InteractionHand.OFF_HAND;
                }
            });
        }
    }
}

