/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import io.redspace.ironsspellbooks.capabilities.spell.SpellData;
import io.redspace.ironsspellbooks.item.Scroll;
import io.redspace.ironsspellbooks.registries.LootRegistry;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class RandomizeSpellFunction
extends LootItemConditionalFunction {
    final NumberProvider qualityRange;
    final List<SpellType> applicableSpells;

    protected RandomizeSpellFunction(LootItemCondition[] lootConditions, NumberProvider qualityRange, List<SpellType> applicableSpells) {
        super(lootConditions);
        this.qualityRange = qualityRange;
        this.applicableSpells = applicableSpells;
    }

    protected ItemStack m_7372_(ItemStack itemStack, LootContext lootContext) {
        if (itemStack.m_41720_() instanceof Scroll || itemStack.m_41720_() instanceof SwordItem) {
            NavigableMap<Integer, SpellType> spellList = this.getWeightedSpellList(this.applicableSpells);
            int total = spellList.floorKey(Integer.MAX_VALUE);
            SpellType spellType = SpellType.NONE_SPELL;
            for (int i = 0; i < 16 && !(spellType = spellList.higherEntry(lootContext.m_78933_().nextInt(total)).getValue()).isEnabled(); ++i) {
            }
            int spellId = spellType.getValue();
            int maxLevel = spellType.getMaxLevel();
            float quality = this.qualityRange.m_142688_(lootContext);
            quality *= (float)Math.sin(1.57 * (double)quality * (double)quality);
            int spellLevel = 1 + Math.round(quality * (float)(maxLevel - 1));
            SpellData.setSpellData(itemStack, spellId, spellLevel);
        }
        return itemStack;
    }

    private NavigableMap<Integer, SpellType> getWeightedSpellList(List<SpellType> entries) {
        int total = 0;
        TreeMap<Integer, SpellType> weightedSpells = new TreeMap<Integer, SpellType>();
        for (SpellType entry : entries) {
            if (entry == SpellType.NONE_SPELL) continue;
            weightedSpells.put(total += this.getWeightFromRarity(SpellRarity.values()[entry.getMinRarity()]), entry);
        }
        return weightedSpells;
    }

    private int getWeightFromRarity(SpellRarity rarity) {
        return switch (rarity) {
            default -> throw new IncompatibleClassChangeError();
            case SpellRarity.COMMON -> 40;
            case SpellRarity.UNCOMMON -> 30;
            case SpellRarity.RARE -> 15;
            case SpellRarity.EPIC -> 8;
            case SpellRarity.LEGENDARY -> 4;
        };
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)LootRegistry.RANDOMIZE_SPELL_FUNCTION.get();
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<RandomizeSpellFunction> {
        public void serialize(JsonObject json, RandomizeSpellFunction scrollFunction, JsonSerializationContext jsonDeserializationContext) {
            super.m_6170_(json, (LootItemConditionalFunction)scrollFunction, jsonDeserializationContext);
        }

        public RandomizeSpellFunction deserialize(JsonObject json, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootConditions) {
            NumberProvider numberProvider = (NumberProvider)GsonHelper.m_13836_((JsonObject)json, (String)"quality", (JsonDeserializationContext)jsonDeserializationContext, NumberProvider.class);
            List<SpellType> applicableSpells = this.getApplicableSpells(json);
            return new RandomizeSpellFunction(lootConditions, numberProvider, applicableSpells);
        }

        private List<SpellType> getApplicableSpells(JsonObject json) {
            if (GsonHelper.m_13900_((JsonObject)json, (String)"school")) {
                String schoolType = GsonHelper.m_13906_((JsonObject)json, (String)"school");
                return switch (schoolType.toLowerCase()) {
                    case "fire" -> SpellType.getSpellsFromSchool(SchoolType.FIRE);
                    case "ice" -> SpellType.getSpellsFromSchool(SchoolType.ICE);
                    case "lightning" -> SpellType.getSpellsFromSchool(SchoolType.LIGHTNING);
                    case "ender" -> SpellType.getSpellsFromSchool(SchoolType.ENDER);
                    case "evocation" -> SpellType.getSpellsFromSchool(SchoolType.EVOCATION);
                    case "holy" -> SpellType.getSpellsFromSchool(SchoolType.HOLY);
                    case "blood" -> SpellType.getSpellsFromSchool(SchoolType.BLOOD);
                    default -> List.of(SpellType.NONE_SPELL);
                };
            }
            if (GsonHelper.m_13885_((JsonObject)json, (String)"spells")) {
                JsonArray spellsFromJson = GsonHelper.m_13933_((JsonObject)json, (String)"spells");
                ArrayList<SpellType> applicableSpellList = new ArrayList<SpellType>();
                for (JsonElement element : spellsFromJson) {
                    String spell = element.getAsString();
                    for (SpellType spellType2 : SpellType.values()) {
                        if (!spellType2.getId().equalsIgnoreCase(spell)) continue;
                        applicableSpellList.add(spellType2);
                    }
                }
                return applicableSpellList;
            }
            return Arrays.stream(SpellType.values()).filter(spellType -> spellType != SpellType.NONE_SPELL).toList();
        }
    }
}

