/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.jei;

import io.redspace.ironsspellbooks.capabilities.spell.SpellData;
import io.redspace.ironsspellbooks.item.InkItem;
import io.redspace.ironsspellbooks.jei.ScrollForgeRecipe;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.ModTags;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public final class ScrollForgeRecipeMaker {
    private ScrollForgeRecipeMaker() {
    }

    public static List<ScrollForgeRecipe> getRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        List<InkItem> inkItems = ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof InkItem).map(item -> (InkItem)((Object)item)).toList();
        Stream<ScrollForgeRecipe> recipes = ForgeRegistries.ITEMS.getValues().stream().filter(item -> item.m_204114_().m_203656_(ModTags.SCHOOL_FOCUS)).map(item -> {
            ItemStack paperInput = new ItemStack((ItemLike)Items.f_42516_);
            ItemStack focusInput = new ItemStack((ItemLike)item);
            SchoolType school = SchoolType.getSchoolFromItem(focusInput);
            List<SpellType> spells = SpellType.getSpellsFromSchool(school);
            ArrayList<ItemStack> scrollOutputs = new ArrayList<ItemStack>();
            ArrayList<ItemStack> inkOutputs = new ArrayList<ItemStack>();
            inkItems.forEach(ink -> spells.forEach(spell -> {
                AbstractSpell spellToUse = spell.getSpellForRarity(ink.getRarity());
                if (spellToUse.getSpellType() != SpellType.NONE_SPELL) {
                    inkOutputs.add(new ItemStack((ItemLike)ink));
                    scrollOutputs.add(ScrollForgeRecipeMaker.getScrollStack(spellToUse.getSpellType(), spellToUse.getLevel(null)));
                }
            }));
            return new ScrollForgeRecipe(inkOutputs, paperInput, focusInput, scrollOutputs);
        });
        return recipes.toList();
    }

    private static ItemStack getScrollStack(SpellType spellType, int spellLevel) {
        ItemStack scrollStack = new ItemStack((ItemLike)ItemRegistry.SCROLL.get());
        SpellData.setSpellData(scrollStack, spellType, spellLevel);
        return scrollStack;
    }

    private record FocusToSchool(Item item, SchoolType schoolType) {
    }
}

