/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.jei;

import io.redspace.ironsspellbooks.capabilities.spell.SpellData;
import io.redspace.ironsspellbooks.gui.arcane_anvil.ArcaneAnvilMenu;
import io.redspace.ironsspellbooks.gui.arcane_anvil.ArcaneAnvilScreen;
import io.redspace.ironsspellbooks.gui.scroll_forge.ScrollForgeMenu;
import io.redspace.ironsspellbooks.gui.scroll_forge.ScrollForgeScreen;
import io.redspace.ironsspellbooks.jei.ArcaneAnvilRecipeCategory;
import io.redspace.ironsspellbooks.jei.ArcaneAnvilRecipeMaker;
import io.redspace.ironsspellbooks.jei.ScrollForgeRecipeCategory;
import io.redspace.ironsspellbooks.jei.ScrollForgeRecipeMaker;
import io.redspace.ironsspellbooks.registries.BlockRegistry;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import io.redspace.ironsspellbooks.spells.SpellType;
import java.util.Arrays;
import java.util.stream.IntStream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@mezz.jei.api.JeiPlugin
public class JeiPlugin
implements IModPlugin {
    public static final String TEXTURE_GUI_PATH = "textures/gui/";
    public static final String TEXTURE_GUI_VANILLA = "textures/gui/gui_vanilla.png";
    public static final String TEXTURE_SCROLL_FORGE = "textures/gui/scroll_forge.png";
    public static final ResourceLocation RECIPE_GUI_VANILLA = new ResourceLocation("irons_spellbooks", "textures/gui/gui_vanilla.png");
    public static final ResourceLocation SCROLL_FORGE_GUI = new ResourceLocation("irons_spellbooks", "textures/gui/scroll_forge.png");
    private static final IIngredientSubtypeInterpreter<ItemStack> SCROLL_INTERPRETER = (stack, context) -> {
        if (stack.m_41782_()) {
            SpellData spellData = SpellData.getSpellData(stack);
            return String.format("scroll:%d:%d", spellData.getSpellId(), spellData.getLevel());
        }
        return "";
    };

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("irons_spellbooks", "jei_plugin");
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)ItemRegistry.SCROLL.get(), SCROLL_INTERPRETER);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new ArcaneAnvilRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ScrollForgeRecipeCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        IIngredientManager ingredientManager = registration.getIngredientManager();
        IVanillaRecipeFactory vanillaRecipeFactory = registration.getVanillaRecipeFactory();
        registration.addRecipes(ArcaneAnvilRecipeCategory.ARCANE_ANVIL_RECIPE_RECIPE_TYPE, ArcaneAnvilRecipeMaker.getRecipes(vanillaRecipeFactory, ingredientManager));
        registration.addRecipes(ScrollForgeRecipeCategory.SCROLL_FORGE_RECIPE_RECIPE_TYPE, ScrollForgeRecipeMaker.getRecipes(vanillaRecipeFactory, ingredientManager));
        Arrays.stream(SpellType.values()).forEach(spellType -> {
            if (spellType.isEnabled() && spellType != SpellType.NONE_SPELL) {
                IntStream.rangeClosed(spellType.getMinLevel(), spellType.getMaxLevel()).forEach(spellLevel -> {
                    ItemStack scrollStack = new ItemStack((ItemLike)ItemRegistry.SCROLL.get());
                    SpellData.setSpellData(scrollStack, spellType, spellLevel);
                    registration.addIngredientInfo((Object)scrollStack, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{io.redspace.ironsspellbooks.util.Component.translatable(String.format("%s.guide", spellType.getComponentId()), new Object[0])});
                });
            }
        });
        registration.addItemStackInfo(new ItemStack((ItemLike)ItemRegistry.LIGHTNING_BOTTLE.get()), new Component[]{io.redspace.ironsspellbooks.util.Component.translatable("item.irons_spellbooks.lightning_bottle.guide", new Object[0])});
        registration.addItemStackInfo(new ItemStack((ItemLike)ItemRegistry.BLOOD_VIAL.get()), new Component[]{io.redspace.ironsspellbooks.util.Component.translatable("item.irons_spellbooks.blood_vial.guide", new Object[0])});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(ArcaneAnvilScreen.class, 102, 48, 22, 15, new RecipeType[]{ArcaneAnvilRecipeCategory.ARCANE_ANVIL_RECIPE_RECIPE_TYPE});
        registration.addRecipeClickArea(ScrollForgeScreen.class, 1, 1, 76, 14, new RecipeType[]{ScrollForgeRecipeCategory.SCROLL_FORGE_RECIPE_RECIPE_TYPE});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(ArcaneAnvilMenu.class, ArcaneAnvilRecipeCategory.ARCANE_ANVIL_RECIPE_RECIPE_TYPE, 0, 2, 3, 36);
        registration.addRecipeTransferHandler(ScrollForgeMenu.class, ArcaneAnvilRecipeCategory.ARCANE_ANVIL_RECIPE_RECIPE_TYPE, 0, 3, 4, 36);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.ARCANE_ANVIL_BLOCK.get()), new RecipeType[]{ArcaneAnvilRecipeCategory.ARCANE_ANVIL_RECIPE_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.SCROLL_FORGE_BLOCK.get()), new RecipeType[]{ScrollForgeRecipeCategory.SCROLL_FORGE_RECIPE_RECIPE_TYPE});
    }
}

