/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.jei;

import io.redspace.ironsspellbooks.capabilities.spell.SpellData;
import io.redspace.ironsspellbooks.jei.ArcaneAnvilRecipe;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import io.redspace.ironsspellbooks.spells.SpellType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.core.Registry;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ItemLike;

public final class ArcaneAnvilRecipeMaker {
    private ArcaneAnvilRecipeMaker() {
    }

    public static List<ArcaneAnvilRecipe> getRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        return Stream.of(ArcaneAnvilRecipeMaker.getScrollRecipes(vanillaRecipeFactory, ingredientManager), ArcaneAnvilRecipeMaker.getImbueRecipes(vanillaRecipeFactory, ingredientManager), ArcaneAnvilRecipeMaker.getUpgradeRecipes(vanillaRecipeFactory, ingredientManager)).flatMap(x -> x).toList();
    }

    private static Stream<ArcaneAnvilRecipe> getScrollRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        return Arrays.stream(SpellType.values()).filter(spellType -> spellType != SpellType.NONE_SPELL && spellType.isEnabled()).sorted(Comparator.comparing(Enum::name)).map(ArcaneAnvilRecipeMaker::enumerateScrollCombinations).filter(ArcaneAnvilRecipe::isValid);
    }

    private static Stream<ArcaneAnvilRecipe> getImbueRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        ItemStack scrollStack = new ItemStack((ItemLike)ItemRegistry.SCROLL.get());
        ArrayList<ItemStack> leftInputs = new ArrayList<ItemStack>();
        ArrayList<ItemStack> rightInputs = new ArrayList<ItemStack>();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        Arrays.stream(SpellType.values()).filter(spellType -> spellType != SpellType.NONE_SPELL && spellType.isEnabled()).sorted(Comparator.comparing(Enum::name)).forEach(spellType -> Registry.f_122827_.m_123024_().filter(k -> k instanceof SwordItem).forEach(swordItem -> {
            ItemStack inputSwordStack = new ItemStack((ItemLike)swordItem);
            IntStream.rangeClosed(spellType.getMinLevel(), spellType.getMaxLevel()).forEach(spellLevel -> {
                leftInputs.add(inputSwordStack);
                rightInputs.add(ArcaneAnvilRecipeMaker.getScrollStack(scrollStack, spellType, spellLevel));
                outputs.add(ArcaneAnvilRecipeMaker.getScrollStack(inputSwordStack, spellType, spellLevel));
            });
        }));
        return Stream.of(new ArcaneAnvilRecipe(leftInputs, rightInputs, outputs));
    }

    private static Stream<ArcaneAnvilRecipe> getUpgradeRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        return Stream.empty();
    }

    private static ArcaneAnvilRecipe enumerateScrollCombinations(SpellType spellType) {
        ItemStack scrollStack = new ItemStack((ItemLike)ItemRegistry.SCROLL.get());
        ArrayList<ItemStack> leftInputs = new ArrayList<ItemStack>();
        ArrayList<ItemStack> rightInputs = new ArrayList<ItemStack>();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        IntStream.range(spellType.getMinLevel(), spellType.getMaxLevel()).forEach(spellLevel -> {
            leftInputs.add(ArcaneAnvilRecipeMaker.getScrollStack(scrollStack, spellType, spellLevel));
            rightInputs.add(ArcaneAnvilRecipeMaker.getScrollStack(scrollStack, spellType, spellLevel));
            outputs.add(ArcaneAnvilRecipeMaker.getScrollStack(scrollStack, spellType, spellLevel + 1));
        });
        return new ArcaneAnvilRecipe(leftInputs, rightInputs, outputs);
    }

    private static ItemStack getScrollStack(ItemStack stack, SpellType spellType, int spellLevel) {
        ItemStack scrollStack = stack.m_41777_();
        SpellData.setSpellData(scrollStack, spellType, spellLevel);
        return scrollStack;
    }
}

