/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.item;

import io.redspace.ironsspellbooks.capabilities.spellbook.SpellBookData;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.CastSource;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.SpellbookModCreativeTabs;
import io.redspace.ironsspellbooks.util.TooltipsUtils;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SpellBook
extends Item {
    protected final SpellRarity f_41369_;
    protected final int spellSlots;

    public SpellBook() {
        this(1, SpellRarity.COMMON);
    }

    public SpellBook(int spellSlots, SpellRarity rarity) {
        this(spellSlots, rarity, new Item.Properties().m_41487_(1).m_41491_(SpellbookModCreativeTabs.SPELL_EQUIPMENT_TAB).m_41497_(Rarity.UNCOMMON));
    }

    public SpellBook(int spellSlots, SpellRarity rarity, Item.Properties pProperties) {
        super(pProperties);
        this.spellSlots = spellSlots;
        this.f_41369_ = rarity;
    }

    public SpellRarity getRarity() {
        return this.f_41369_;
    }

    public int getSpellSlots() {
        return this.spellSlots;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        SpellBookData spellBookData = SpellBookData.getSpellBookData(itemStack);
        AbstractSpell spell = spellBookData.getActiveSpell();
        if (spell.getSpellType() == SpellType.NONE_SPELL) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        if (level.m_5776_()) {
            if (ClientMagicData.isCasting()) {
                return InteractionResultHolder.m_19100_((Object)itemStack);
            }
            if (ClientMagicData.getPlayerMana() < spell.getManaCost() || ClientMagicData.getCooldowns().isOnCooldown(spell.getSpellType())) {
                return InteractionResultHolder.m_19098_((Object)itemStack);
            }
            if (spell.getCastType().holdToCast()) {
                player.m_6672_(hand);
            }
            return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
        }
        if (spell.attemptInitiateCast(itemStack, level, player, CastSource.SPELLBOOK, true)) {
            if (spell.getCastType().holdToCast()) {
                player.m_6672_(hand);
            }
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        return InteractionResultHolder.m_19100_((Object)itemStack);
    }

    public int m_8105_(ItemStack itemStack) {
        return 7200;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public void m_5551_(ItemStack itemStack, Level p_41413_, LivingEntity entity, int p_41415_) {
        entity.m_5810_();
        Utils.releaseUsingHelper(entity);
        super.m_5551_(itemStack, p_41413_, entity, p_41415_);
    }

    public boolean isUnique() {
        return false;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> lines, TooltipFlag flag) {
        if (!this.isUnique()) {
            lines.add((Component)io.redspace.ironsspellbooks.util.Component.translatable("tooltip.irons_spellbooks.spellbook_rarity", this.f_41369_.getDisplayName()).m_130940_(ChatFormatting.GRAY));
        } else {
            lines.add((Component)io.redspace.ironsspellbooks.util.Component.translatable("tooltip.irons_spellbooks.spellbook_rarity", io.redspace.ironsspellbooks.util.Component.translatable("tooltip.irons_spellbooks.spellbook_unique", new Object[0]).m_130948_(Style.f_131099_.m_178520_(14697252))).m_130940_(ChatFormatting.GRAY));
        }
        lines.add((Component)io.redspace.ironsspellbooks.util.Component.translatable("tooltip.irons_spellbooks.spellbook_spell_count", this.spellSlots).m_130940_(ChatFormatting.GRAY));
        if (SpellBookData.getSpellBookData(itemStack).getActiveSpell().getID() > 0) {
            lines.addAll(TooltipsUtils.formatActiveSpellTooltip(itemStack, CastSource.SPELLBOOK));
        }
        super.m_7373_(itemStack, level, lines, flag);
    }
}

