/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.gui.scroll_forge;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.gui.scroll_forge.ScrollForgeMenu;
import io.redspace.ironsspellbooks.gui.scroll_forge.network.ServerboundScrollForgeSelectSpell;
import io.redspace.ironsspellbooks.item.InkItem;
import io.redspace.ironsspellbooks.setup.Messages;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.ModTags;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ScrollForgeScreen
extends AbstractContainerScreen<ScrollForgeMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("irons_spellbooks", "textures/gui/scroll_forge.png");
    private static final int SPELL_LIST_X = 89;
    private static final int SPELL_LIST_Y = 15;
    public static final ResourceLocation RUNIC_FONT = new ResourceLocation("illageralt");
    private List<SpellCardInfo> availableSpells;
    private ItemStack[] oldMenuSlots = new ItemStack[]{ItemStack.f_41583_, ItemStack.f_41583_, ItemStack.f_41583_};
    private SpellType selectedSpell = SpellType.NONE_SPELL;
    private int scrollOffset;

    public ScrollForgeScreen(ScrollForgeMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.f_97726_ = 218;
        this.f_97727_ = 166;
    }

    protected void m_7856_() {
        this.availableSpells = new ArrayList<SpellCardInfo>();
        this.generateSpellList();
        super.m_7856_();
    }

    public void m_7379_() {
        this.selectedSpell = SpellType.NONE_SPELL;
        this.resetList();
        super.m_7379_();
    }

    private void resetList() {
        InkItem inkItem;
        Item item;
        if (((ScrollForgeMenu)this.f_97732_).getInkSlot().m_7993_().m_41619_() || !((item = ((ScrollForgeMenu)this.f_97732_).getInkSlot().m_7993_().m_41720_()) instanceof InkItem) || (inkItem = (InkItem)item).getRarity().compareRarity(ServerConfigs.getSpellConfig(this.selectedSpell).minRarity()) < 0) {
            this.selectedSpell = SpellType.NONE_SPELL;
        }
        this.scrollOffset = 0;
        for (SpellCardInfo s : this.availableSpells) {
            this.m_169411_((GuiEventListener)s.button);
        }
        this.availableSpells.clear();
        Messages.sendToServer(new ServerboundScrollForgeSelectSpell(((ScrollForgeMenu)this.f_97732_).blockEntity.m_58899_(), this.selectedSpell.getValue()));
    }

    public void m_6305_(PoseStack pPoseStack, int mouseX, int mouseY, float delta) {
        this.m_7333_(pPoseStack);
        super.m_6305_(pPoseStack, mouseX, mouseY, delta);
        this.m_7025_(pPoseStack, mouseX, mouseY);
    }

    protected void m_7286_(PoseStack poseStack, float partialTick, int mouseX, int mouseY) {
        this.setTexture(TEXTURE);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        if (this.menuSlotsChanged()) {
            this.generateSpellList();
        }
        this.renderSpellList(poseStack, partialTick, mouseX, mouseY);
    }

    private boolean menuSlotsChanged() {
        if (((ScrollForgeMenu)this.f_97732_).getInkSlot().m_7993_().m_41720_() != this.oldMenuSlots[0].m_41720_() || ((ScrollForgeMenu)this.f_97732_).getFocusSlot().m_7993_().m_41720_() != this.oldMenuSlots[2].m_41720_()) {
            this.oldMenuSlots = new ItemStack[]{((ScrollForgeMenu)this.f_97732_).getInkSlot().m_7993_(), ((ScrollForgeMenu)this.f_97732_).getBlankScrollSlot().m_7993_(), ((ScrollForgeMenu)this.f_97732_).getFocusSlot().m_7993_()};
            return true;
        }
        return false;
    }

    private void renderSpellList(PoseStack poseStack, float partialTick, int mouseX, int mouseY) {
        ItemStack inkStack = ((ScrollForgeMenu)this.f_97732_).getInkSlot().m_7993_();
        SpellRarity inkRarity = this.getRarityFromInk(inkStack.m_41720_());
        this.availableSpells.sort((a, b) -> ServerConfigs.getSpellConfig(a.spell).minRarity().compareRarity(ServerConfigs.getSpellConfig(b.spell).minRarity()));
        for (int i = 0; i < this.availableSpells.size(); ++i) {
            SpellCardInfo spellCard = this.availableSpells.get(i);
            if (i - this.scrollOffset >= 0 && i - this.scrollOffset < 3) {
                spellCard.button.f_93623_ = inkRarity != null && spellCard.spell.getMinRarity() <= inkRarity.getValue();
                int x = this.f_97735_ + 89;
                int y = this.f_97736_ + 15 + (i - this.scrollOffset) * 19;
                spellCard.button.f_93620_ = x;
                spellCard.button.f_93621_ = y;
                spellCard.draw(this, poseStack, x, y, mouseX, mouseY);
                continue;
            }
            spellCard.button.f_93623_ = false;
        }
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double direction) {
        int newScroll = this.scrollOffset - (int)direction;
        int length = this.availableSpells.size();
        if (newScroll <= length - 3 && newScroll >= 0) {
            this.scrollOffset = (int)((double)this.scrollOffset - direction);
            return true;
        }
        return false;
    }

    public void generateSpellList() {
        this.resetList();
        ItemStack focusStack = ((ScrollForgeMenu)this.f_97732_).getFocusSlot().m_7993_();
        IronsSpellbooks.LOGGER.info("ScrollForgeMenu.generateSpellSlots.focus: {}", (Object)focusStack.m_41720_());
        if (!focusStack.m_41619_() && focusStack.m_204117_(ModTags.SCHOOL_FOCUS)) {
            SchoolType school = SchoolType.getSchoolFromItem(focusStack);
            List<SpellType> spells = SpellType.getSpellsFromSchool(school);
            for (int i = 0; i < spells.size(); ++i) {
                int tempIndex = i;
                if (!spells.get(i).isEnabled()) continue;
                this.availableSpells.add(new SpellCardInfo(spells.get(i), i + 1, i, (Button)this.m_7787_((GuiEventListener)new Button(0, 0, 108, 19, (Component)spells.get(i).getDisplayName(), b -> this.setSelectedSpell((SpellType)((Object)((Object)spells.get(tempIndex))))))));
            }
        }
    }

    private void setSelectedSpell(SpellType spell) {
        this.selectedSpell = spell;
        Messages.sendToServer(new ServerboundScrollForgeSelectSpell(((ScrollForgeMenu)this.f_97732_).blockEntity.m_58899_(), spell.getValue()));
    }

    private SpellRarity getRarityFromInk(Item ink) {
        if (ink instanceof InkItem) {
            InkItem inkItem = (InkItem)ink;
            return inkItem.getRarity();
        }
        return null;
    }

    public SpellType getSelectedSpell() {
        return this.selectedSpell;
    }

    private void setTexture(ResourceLocation texture) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
    }

    private class SpellCardInfo {
        SpellType spell;
        int spellLevel;
        SpellRarity rarity;
        Button button;
        int index;

        SpellCardInfo(SpellType spell, int spellLevel, int index, Button button) {
            this.spell = spell;
            this.spellLevel = spellLevel;
            this.index = index;
            this.button = button;
            this.rarity = spell.getRarity(spellLevel);
        }

        void draw(ScrollForgeScreen screen, PoseStack poseStack, int x, int y, int mouseX, int mouseY) {
            ScrollForgeScreen.this.setTexture(TEXTURE);
            int maxWidth = 88;
            FormattedText text = this.trimText(ScrollForgeScreen.this.f_96547_, (Component)this.getDisplayName().m_130948_(this.button.f_93623_ ? Style.f_131099_ : Style.f_131099_.m_131150_(RUNIC_FONT)), maxWidth);
            if (this.button.f_93623_) {
                if (this.spell == screen.getSelectedSpell()) {
                    screen.m_93228_(poseStack, x, y, 0, 204, 108, 19);
                } else {
                    screen.m_93228_(poseStack, x, y, 0, 166, 108, 19);
                }
            } else {
                screen.m_93228_(poseStack, x, y, 0, 185, 108, 19);
            }
            ScrollForgeScreen.this.setTexture(this.button.f_93623_ ? this.spell.getResourceLocation() : SpellType.NONE_SPELL.getResourceLocation());
            ScrollForgeScreen.m_93133_((PoseStack)poseStack, (int)(x + 108 - 18), (int)(y + 1), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            int textX = x + 2;
            int textY = y + 3;
            ScrollForgeScreen.this.f_96547_.m_92857_(text, textX, textY, maxWidth, 0xFFFFFF);
            if (mouseX >= textX && mouseY >= textY && mouseX < textX + ScrollForgeScreen.this.f_96547_.m_92852_(text)) {
                Objects.requireNonNull(ScrollForgeScreen.this.f_96547_);
                if (mouseY < textY + 9) {
                    screen.m_96602_(poseStack, (Component)this.getHoverText(), mouseX, mouseY);
                }
            }
        }

        MutableComponent getHoverText() {
            return this.button.f_93623_ ? this.getDisplayName() : io.redspace.ironsspellbooks.util.Component.translatable("ui.irons_spellbooks.ink_rarity_error", new Object[0]);
        }

        private FormattedText trimText(Font font, Component component, int maxWidth) {
            FormattedText text = (FormattedText)font.m_92865_().m_92414_((FormattedText)component, maxWidth, component.m_7383_()).get(0);
            if (text.getString().length() < component.getString().length()) {
                text = FormattedText.m_130773_((FormattedText[])new FormattedText[]{text, FormattedText.m_130775_((String)"...")});
            }
            return text;
        }

        MutableComponent getDisplayName() {
            return this.spell.getDisplayName();
        }
    }
}

