/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.gui.overlays;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Vector4f;
import io.redspace.ironsspellbooks.capabilities.spellbook.SpellBookData;
import io.redspace.ironsspellbooks.gui.overlays.network.ServerboundSetSpellBookActiveIndex;
import io.redspace.ironsspellbooks.item.SpellBook;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import io.redspace.ironsspellbooks.setup.Messages;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.client.gui.ForgeIngameGui;
import org.apache.commons.lang3.ArrayUtils;

public class SpellWheelOverlay
extends GuiComponent {
    public static SpellWheelOverlay instance = new SpellWheelOverlay();
    public static final ResourceLocation TEXTURE = new ResourceLocation("irons_spellbooks", "textures/gui/icons.png");
    public static final ResourceLocation WHEEL = new ResourceLocation("irons_spellbooks", "textures/gui/spell_wheel.png");
    private final Vector4f lineColor = new Vector4f(1.0f, 0.85f, 0.7f, 1.0f);
    private final Vector4f radialButtonColor = new Vector4f(0.04f, 0.03f, 0.01f, 0.6f);
    private final Vector4f highlightColor = new Vector4f(0.8f, 0.7f, 0.55f, 0.7f);
    private final double ringInnerEdge = 20.0;
    private double ringOuterEdge = 80.0;
    private final double ringOuterEdgeMax = 80.0;
    private final double ringOuterEdgeMin = 65.0;
    private final double categoryLineWidth = 2.0;
    public boolean active;
    private int selection;
    private int selectedSpellIndex;
    private SpellBookData spellBookData;

    public void open() {
        this.active = true;
        this.selection = -1;
        this.selectedSpellIndex = -1;
        Minecraft.m_91087_().f_91067_.m_91602_();
    }

    public void close() {
        this.active = false;
        if (this.selectedSpellIndex >= 0) {
            Messages.sendToServer(new ServerboundSetSpellBookActiveIndex(this.selectedSpellIndex));
        }
        Minecraft.m_91087_().f_91067_.m_91601_();
    }

    public void render(ForgeIngameGui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
        int i;
        if (!this.active) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null || minecraft.f_91080_ != null || minecraft.f_91067_.m_91600_() || !Utils.isPlayerHoldingSpellBook((Player)minecraft.f_91074_)) {
            this.active = false;
            return;
        }
        poseStack.m_85836_();
        LocalPlayer player = minecraft.f_91074_;
        int centerX = screenWidth / 2;
        int centerY = screenHeight / 2;
        ItemStack spellBookStack = player.m_21205_().m_41720_() instanceof SpellBook ? player.m_21205_() : player.m_21206_();
        this.spellBookData = SpellBookData.getSpellBookData(spellBookStack);
        List<AbstractSpell> spells = this.spellBookData.getActiveInscribedSpells();
        int spellCount = spells.size();
        if (spellCount == 0) {
            this.close();
            return;
        }
        Vec2 screenCenter = new Vec2((float)minecraft.m_91268_().m_85443_() * 0.5f, (float)minecraft.m_91268_().m_85444_() * 0.5f);
        Vec2 mousePos = new Vec2((float)minecraft.f_91067_.m_91589_(), (float)minecraft.f_91067_.m_91594_());
        double radiansPerSpell = Math.toRadians(360.0f / (float)spellCount);
        float mouseRotation = (Utils.getAngle(mousePos, screenCenter) + 1.57f + (float)radiansPerSpell * 0.5f) % 6.283f;
        this.selection = (int)Mth.m_14008_((double)((double)mouseRotation / radiansPerSpell), (double)0.0, (double)(spellCount - 1));
        if ((double)mousePos.m_165914_(screenCenter) < 4225.0) {
            this.selection = Math.max(0, this.spellBookData.getActiveSpellIndex());
        }
        AbstractSpell currentSpell = spells.get(this.selection);
        this.selectedSpellIndex = ArrayUtils.indexOf((Object[])this.spellBookData.getInscribedSpells(), (Object)currentSpell);
        SpellWheelOverlay.m_93172_((PoseStack)poseStack, (int)0, (int)0, (int)screenWidth, (int)screenHeight, (int)0);
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        double quarterCircle = 1.5707963267948966;
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        this.drawRadialBackgrounds(buffer, centerX, centerY, this.selection, spells);
        this.drawDividingLines(buffer, centerX, centerY, spells);
        float scale = Mth.m_14036_((float)(1.0f + (float)(15 - spellCount) / 15.0f), (float)1.0f, (float)2.0f) * 0.65f;
        double radius = (double)(3.0f / scale) * 40.0 * 0.5 * (double)(0.85f + 0.15f * ((float)spells.size() / 15.0f));
        Vec2[] locations = new Vec2[spellCount];
        for (i = 0; i < locations.length; ++i) {
            locations[i] = new Vec2((float)(Math.sin(radiansPerSpell * (double)i) * radius), (float)(-Math.cos(radiansPerSpell * (double)i) * radius));
        }
        tesselator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
        for (i = 0; i < locations.length; ++i) {
            float f;
            AbstractSpell spell = spells.get(i);
            if (spell == null) continue;
            this.setOpaqueTexture(spells.get(i).getSpellType().getResourceLocation());
            poseStack.m_85836_();
            poseStack.m_85837_((double)centerX, (double)centerY, 0.0);
            poseStack.m_85841_(scale, scale, scale);
            int iconWidth = 8;
            int borderWidth = 16;
            int cdWidth = 8;
            SpellWheelOverlay.m_93133_((PoseStack)poseStack, (int)((int)locations[i].f_82470_ - iconWidth), (int)((int)locations[i].f_82471_ - iconWidth), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            this.setTranslucentTexture(TEXTURE);
            this.m_93228_(poseStack, (int)locations[i].f_82470_ - borderWidth, (int)locations[i].f_82471_ - borderWidth, this.selection == i ? 32 : 0, 106, 32, 32);
            float f2 = f = spells.get(i) == null ? 0.0f : ClientMagicData.getCooldownPercent(spells.get(i).getSpellType());
            if (f > 0.0f) {
                int pixels = (int)(16.0f * f + 1.0f);
                gui.m_93228_(poseStack, (int)locations[i].f_82470_ - cdWidth, (int)locations[i].f_82471_ + cdWidth - pixels, 47, 87, 16, pixels);
            }
            poseStack.m_85849_();
        }
        AbstractSpell selectedSpell = spells.get(this.selection);
        if (selectedSpell != null) {
            Font font = gui.m_93082_();
            MutableComponent title = currentSpell.getSpellType().getDisplayName().m_130948_(Style.f_131099_.m_131162_(Boolean.valueOf(true)));
            MutableComponent level = io.redspace.ironsspellbooks.util.Component.translatable("ui.irons_spellbooks.level", selectedSpell.getLevel(null)).m_130948_(selectedSpell.getSpellType().getRarity(selectedSpell.getLevel(null)).getDisplayName().m_7383_());
            MutableComponent mana = io.redspace.ironsspellbooks.util.Component.translatable("ui.irons_spellbooks.mana_cost", selectedSpell.getManaCost()).m_130940_(ChatFormatting.AQUA);
            Objects.requireNonNull(font);
            int height = 2 * 9 + 5;
            font.m_92763_(poseStack, (Component)title, (float)(centerX - font.m_92852_((FormattedText)title) / 2), (float)((double)centerY - (this.ringOuterEdge + (double)height)), 0xFFFFFF);
            float f = centerX - font.m_92852_((FormattedText)level) - 5;
            double d = (double)centerY - (this.ringOuterEdge + (double)height);
            Objects.requireNonNull(font);
            font.m_92763_(poseStack, (Component)level, f, (float)(d + 9.0 + 5.0), 0xFFFFFF);
            float f3 = centerX + 5;
            double d2 = (double)centerY - (this.ringOuterEdge + (double)height);
            Objects.requireNonNull(font);
            font.m_92763_(poseStack, (Component)mana, f3, (float)(d2 + 9.0 + 5.0), 0xFFFFFF);
            List<MutableComponent> info = selectedSpell.getUniqueInfo((LivingEntity)minecraft.f_91074_);
            for (int i2 = 0; i2 < info.size(); ++i2) {
                MutableComponent line = info.get(i2);
                MutableComponent mutableComponent = line.m_130940_(ChatFormatting.GREEN);
                float f4 = (float)centerX - (float)font.m_92852_((FormattedText)line) / 2.0f;
                double d3 = (double)centerY + 80.0;
                Objects.requireNonNull(font);
                font.m_92763_(poseStack, (Component)mutableComponent, f4, (float)(d3 + (double)(9 * i2)), 0xFFFFFF);
            }
        }
        poseStack.m_85849_();
    }

    private void drawRadialBackgrounds(BufferBuilder buffer, double centerX, double centerY, int selectedSpellIndex, List<AbstractSpell> spells) {
        double quarterCircle = 1.5707963267948966;
        int segments = spells.size() < 6 ? (spells.size() % 2 == 1 ? 15 : 12) : spells.size() * 2;
        double radiansPerObject = Math.PI * 2 / (double)segments;
        double radiansPerSpell = Math.PI * 2 / (double)spells.size();
        this.ringOuterEdge = Math.max(65.0, 80.0);
        double fragment = 0.0;
        double fragment2 = 0.0;
        for (int i = 0; i < segments; ++i) {
            AbstractSpell spell = i > spells.size() - 1 ? null : spells.get(i);
            double beginRadians = (double)i * radiansPerObject - (quarterCircle + radiansPerSpell / 2.0);
            double endRadians = (double)(i + 1) * radiansPerObject - (quarterCircle + radiansPerSpell / 2.0);
            double x1m1 = Math.cos(beginRadians + 0.0) * 20.0;
            double x2m1 = Math.cos(endRadians - 0.0) * 20.0;
            double y1m1 = Math.sin(beginRadians + 0.0) * 20.0;
            double y2m1 = Math.sin(endRadians - 0.0) * 20.0;
            double x1m2 = Math.cos(beginRadians + 0.0) * this.ringOuterEdge;
            double x2m2 = Math.cos(endRadians - 0.0) * this.ringOuterEdge;
            double y1m2 = Math.sin(beginRadians + 0.0) * this.ringOuterEdge;
            double y2m2 = Math.sin(endRadians - 0.0) * this.ringOuterEdge;
            boolean isSelected = spell != null && this.spellBookData.getActiveSpell().getID() == spell.getID();
            int extendBy = 10;
            boolean isHighlighted = i * spells.size() / segments == selectedSpellIndex;
            Vector4f color = this.radialButtonColor;
            if (isHighlighted) {
                color = this.highlightColor;
            }
            buffer.m_5483_(centerX + x1m1, centerY + y1m1, (double)this.m_93252_()).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_5752_();
            buffer.m_5483_(centerX + x2m1, centerY + y2m1, (double)this.m_93252_()).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_5752_();
            buffer.m_5483_(centerX + x2m2, centerY + y2m2, (double)this.m_93252_()).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), 0.0f).m_5752_();
            buffer.m_5483_(centerX + x1m2, centerY + y1m2, (double)this.m_93252_()).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), 0.0f).m_5752_();
            color = this.lineColor;
            double categoryLineOuterEdge = 22.0;
            double x1m3 = Math.cos(beginRadians + 0.0) * 22.0;
            double x2m3 = Math.cos(endRadians - 0.0) * 22.0;
            double y1m3 = Math.sin(beginRadians + 0.0) * 22.0;
            double y2m3 = Math.sin(endRadians - 0.0) * 22.0;
            buffer.m_5483_(centerX + x1m1, centerY + y1m1, (double)this.m_93252_()).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_5752_();
            buffer.m_5483_(centerX + x2m1, centerY + y2m1, (double)this.m_93252_()).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_5752_();
            buffer.m_5483_(centerX + x2m3, centerY + y2m3, (double)this.m_93252_()).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_5752_();
            buffer.m_5483_(centerX + x1m3, centerY + y1m3, (double)this.m_93252_()).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_5752_();
        }
    }

    private void drawDividingLines(BufferBuilder buffer, double centerX, double centerY, List<AbstractSpell> spells) {
        if (spells.size() <= 1) {
            return;
        }
        double quarterCircle = 1.5707963267948966;
        double radiansPerSpell = Math.PI * 2 / (double)spells.size();
        this.ringOuterEdge = Math.max(65.0, 80.0);
        for (int i = 0; i < spells.size(); ++i) {
            double closeWidth = 0.13962633907794952;
            double farWidth = 0.03490658476948738;
            double beginCloseRadians = (double)i * radiansPerSpell - (quarterCircle + radiansPerSpell / 2.0) - 0.03490658476948738;
            double endCloseRadians = beginCloseRadians + 0.13962633907794952;
            double beginFarRadians = (double)i * radiansPerSpell - (quarterCircle + radiansPerSpell / 2.0) - 0.008726646192371845;
            double endFarRadians = beginCloseRadians + 0.03490658476948738;
            double x1m1 = Math.cos(beginCloseRadians) * 20.0;
            double x2m1 = Math.cos(endCloseRadians) * 20.0;
            double y1m1 = Math.sin(beginCloseRadians) * 20.0;
            double y2m1 = Math.sin(endCloseRadians) * 20.0;
            double x1m2 = Math.cos(beginFarRadians) * this.ringOuterEdge * 1.4;
            double x2m2 = Math.cos(endFarRadians) * this.ringOuterEdge * 1.4;
            double y1m2 = Math.sin(beginFarRadians) * this.ringOuterEdge * 1.4;
            double y2m2 = Math.sin(endFarRadians) * this.ringOuterEdge * 1.4;
            Vector4f color = this.lineColor;
            buffer.m_5483_(centerX + x1m1, centerY + y1m1, (double)this.m_93252_()).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_5752_();
            buffer.m_5483_(centerX + x2m1, centerY + y2m1, (double)this.m_93252_()).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_()).m_5752_();
            buffer.m_5483_(centerX + x2m2, centerY + y2m2, (double)this.m_93252_()).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), 0.0f).m_5752_();
            buffer.m_5483_(centerX + x1m2, centerY + y1m2, (double)this.m_93252_()).m_85950_(color.m_123601_(), color.m_123615_(), color.m_123616_(), 0.0f).m_5752_();
        }
    }

    private void setOpaqueTexture(ResourceLocation texture) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
    }

    private void setTranslucentTexture(ResourceLocation texture) {
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172649_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
    }

    private boolean inTriangle(double x1, double y1, double x2, double y2, double x3, double y3, double x, double y) {
        double ab = (x1 - x) * (y2 - y) - (x2 - x) * (y1 - y);
        double bc = (x2 - x) * (y3 - y) - (x3 - x) * (y2 - y);
        double ca = (x3 - x) * (y1 - y) - (x1 - x) * (y3 - y);
        return this.sign(ab) == this.sign(bc) && this.sign(bc) == this.sign(ca);
    }

    private int sign(double n) {
        return n > 0.0 ? 1 : -1;
    }
}

