/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.gui.overlays;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.redspace.ironsspellbooks.capabilities.spellbook.SpellBookData;
import io.redspace.ironsspellbooks.item.SpellBook;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import io.redspace.ironsspellbooks.player.ClientRenderCache;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.client.gui.ForgeIngameGui;

public class SpellBarOverlay
extends GuiComponent {
    public static final ResourceLocation TEXTURE = new ResourceLocation("irons_spellbooks", "textures/gui/icons.png");
    static final int IMAGE_HEIGHT = 21;
    static final int IMAGE_WIDTH = 21;
    static final int HOTBAR_HALFWIDTH = 91;
    static final int boxSize = 20;
    static int screenHeight;
    static int screenWidth;
    private static ItemStack lastSpellBook;

    public static void render(ForgeIngameGui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
        int i;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (!Utils.isPlayerHoldingSpellBook((Player)player)) {
            return;
        }
        int centerX = screenWidth / 2 - Math.max(110, screenWidth / 4);
        int centerY = screenHeight - Math.max(55, screenHeight / 8);
        ItemStack spellBookStack = player.m_21205_().m_41720_() instanceof SpellBook ? player.m_21205_() : player.m_21206_();
        SpellBookData spellBookData = SpellBookData.getSpellBookData(spellBookStack);
        if (spellBookStack != lastSpellBook) {
            lastSpellBook = spellBookStack;
            ClientRenderCache.generateRelativeLocations(spellBookData, 20, 22);
        }
        AbstractSpell[] spells = spellBookData.getInscribedSpells();
        List<Vec2> locations = ClientRenderCache.relativeSpellBarSlotLocations;
        int approximateWidth = locations.size() / 3;
        centerX -= approximateWidth * 5;
        SpellBarOverlay.setTranslucentTexture(TEXTURE);
        for (Vec2 location : locations) {
            gui.m_93228_(poseStack, centerX + (int)location.f_82470_, centerY + (int)location.f_82471_, 66, 84, 22, 22);
        }
        for (i = 0; i < locations.size(); ++i) {
            if (spells[i] == null) continue;
            SpellBarOverlay.setOpaqueTexture(spells[i].getSpellType().getResourceLocation());
            ForgeIngameGui.m_93133_((PoseStack)poseStack, (int)(centerX + (int)locations.get((int)i).f_82470_ + 3), (int)(centerY + (int)locations.get((int)i).f_82471_ + 3), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        }
        for (i = 0; i < locations.size(); ++i) {
            float f;
            SpellBarOverlay.setTranslucentTexture(TEXTURE);
            if (i != spellBookData.getActiveSpellIndex()) {
                gui.m_93228_(poseStack, centerX + (int)locations.get((int)i).f_82470_, centerY + (int)locations.get((int)i).f_82471_, 22, 84, 22, 22);
            }
            float f2 = f = spells[i] == null ? 0.0f : ClientMagicData.getCooldownPercent(spells[i].getSpellType());
            if (!(f > 0.0f)) continue;
            int pixels = (int)(16.0f * f + 1.0f);
            gui.m_93228_(poseStack, centerX + (int)locations.get((int)i).f_82470_ + 3, centerY + (int)locations.get((int)i).f_82471_ + 19 - pixels, 47, 87, 16, pixels);
        }
        for (i = 0; i < locations.size(); ++i) {
            SpellBarOverlay.setTranslucentTexture(TEXTURE);
            if (i != spellBookData.getActiveSpellIndex()) continue;
            gui.m_93228_(poseStack, centerX + (int)locations.get((int)i).f_82470_, centerY + (int)locations.get((int)i).f_82471_, 0, 84, 22, 22);
        }
    }

    private static void setOpaqueTexture(ResourceLocation texture) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
    }

    private static void setTranslucentTexture(ResourceLocation texture) {
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172649_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
    }

    static {
        lastSpellBook = ItemStack.f_41583_;
    }
}

