/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.gui.inscription_table;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.redspace.ironsspellbooks.capabilities.spell.SpellData;
import io.redspace.ironsspellbooks.capabilities.spellbook.SpellBookData;
import io.redspace.ironsspellbooks.gui.inscription_table.InscriptionTableMenu;
import io.redspace.ironsspellbooks.item.Scroll;
import io.redspace.ironsspellbooks.item.SpellBook;
import io.redspace.ironsspellbooks.item.UniqueSpellBook;
import io.redspace.ironsspellbooks.player.ClientRenderCache;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.util.TooltipsUtils;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;

public class InscriptionTableScreen
extends AbstractContainerScreen<InscriptionTableMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("irons_spellbooks", "textures/gui/inscription_table.png");
    private static final int INSCRIBE_BUTTON_X = 43;
    private static final int INSCRIBE_BUTTON_Y = 35;
    private static final int EXTRACT_BUTTON_X = 188;
    private static final int EXTRACT_BUTTON_Y = 137;
    private static final int SPELLBOOK_SLOT = 36;
    private static final int SCROLL_SLOT = 37;
    private static final int EXTRACTION_SLOT = 38;
    private static final int SPELL_BG_X = 67;
    private static final int SPELL_BG_Y = 15;
    private static final int SPELL_BG_WIDTH = 95;
    private static final int SPELL_BG_HEIGHT = 57;
    private static final int LORE_PAGE_X = 176;
    private static final int LORE_PAGE_WIDTH = 80;
    private boolean isDirty;
    protected Button inscribeButton;
    private ItemStack lastSpellBookItem = ItemStack.f_41583_;
    protected ArrayList<SpellSlotInfo> spellSlots;
    private int selectedSpellIndex = -1;
    private int inscriptionErrorCode = 0;
    private final int[][] LAYOUT = ClientRenderCache.SPELL_LAYOUT;

    public InscriptionTableScreen(InscriptionTableMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.f_97726_ = 256;
        this.f_97727_ = 166;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.inscribeButton = (Button)this.m_7787_((GuiEventListener)new Button(0, 0, 14, 14, CommonComponents.f_130655_, p_169820_ -> this.onInscription()));
        this.spellSlots = new ArrayList();
        this.generateSpellSlots();
    }

    public void m_7379_() {
        this.resetSelectedSpell();
        super.m_7379_();
    }

    public void m_6305_(PoseStack pPoseStack, int mouseX, int mouseY, float delta) {
        this.m_7333_(pPoseStack);
        super.m_6305_(pPoseStack, mouseX, mouseY, delta);
        this.m_7025_(pPoseStack, mouseX, mouseY);
    }

    protected void m_7286_(PoseStack poseStack, float partialTick, int mouseX, int mouseY) {
        this.setTexture(TEXTURE);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        this.inscribeButton.f_93623_ = this.isValidInscription() && this.inscriptionErrorCode == 0;
        this.renderButtons(poseStack, mouseX, mouseY);
        if (((Slot)((InscriptionTableMenu)this.f_97732_).f_38839_.get(36)).m_7993_() != this.lastSpellBookItem) {
            this.onSpellBookSlotChanged();
            this.lastSpellBookItem = ((Slot)((InscriptionTableMenu)this.f_97732_).f_38839_.get(36)).m_7993_();
        }
        this.renderSpells(poseStack, mouseX, mouseY);
        this.renderLorePage(poseStack, partialTick, mouseX, mouseY);
        this.inscriptionErrorCode = ((Slot)((InscriptionTableMenu)this.f_97732_).f_38839_.get(36)).m_6657_() ? this.getErrorCode() : 0;
        if (this.inscriptionErrorCode > 0) {
            this.setTexture(TEXTURE);
            this.m_93228_(poseStack, this.f_97735_ + 35, this.f_97736_ + 51, 0, 213, 28, 22);
            if (this.isHovering(this.f_97735_ + 35, this.f_97736_ + 51, 28, 22, mouseX, mouseY)) {
                this.m_96602_(poseStack, this.getErrorMessage(this.inscriptionErrorCode), mouseX, mouseY);
            }
        }
    }

    private int getErrorCode() {
        Item item = ((InscriptionTableMenu)this.f_97732_).getSpellBookSlot().m_7993_().m_41720_();
        if (item instanceof SpellBook) {
            SpellBook spellbook = (SpellBook)item;
            item = ((InscriptionTableMenu)this.f_97732_).getScrollSlot().m_7993_().m_41720_();
            if (item instanceof Scroll) {
                Scroll scroll = (Scroll)item;
                SpellData scrollData = SpellData.getSpellData(((InscriptionTableMenu)this.f_97732_).getScrollSlot().m_7993_());
                if (spellbook.getRarity().compareRarity(scrollData.getSpell().getRarity()) < 0) {
                    return 1;
                }
            }
        }
        return 0;
    }

    private Component getErrorMessage(int code) {
        if (code == 1) {
            return io.redspace.ironsspellbooks.util.Component.translatable("ui.irons_spellbooks.inscription_table_rarity_error", new Object[0]);
        }
        return io.redspace.ironsspellbooks.util.Component.empty();
    }

    private void renderSpells(PoseStack poseStack, int mouseX, int mouseY) {
        if (this.isDirty) {
            this.generateSpellSlots();
        }
        Vec2 center = new Vec2((float)(67 + this.f_97735_ + 47), (float)(15 + this.f_97736_ + 28));
        for (int i = 0; i < this.spellSlots.size(); ++i) {
            Button spellSlot = this.spellSlots.get((int)i).button;
            Vec2 pos = this.spellSlots.get((int)i).relativePosition.m_165910_(center);
            spellSlot.f_93620_ = (int)pos.f_82470_;
            spellSlot.f_93621_ = (int)pos.f_82471_;
            this.renderSpellSlot(poseStack, pos, mouseX, mouseY, i, this.spellSlots.get(i));
        }
    }

    private void renderButtons(PoseStack poseStack, int mouseX, int mouseY) {
        this.inscribeButton.f_93620_ = this.f_97735_ + 43;
        this.inscribeButton.f_93621_ = this.f_97736_ + 35;
        if (this.inscribeButton.f_93623_) {
            if (this.isHovering(this.inscribeButton.f_93620_, this.inscribeButton.f_93621_, 14, 14, mouseX, mouseY)) {
                this.m_93228_(poseStack, this.inscribeButton.f_93620_, this.inscribeButton.f_93621_, 28, 185, 14, 14);
            } else {
                this.m_93228_(poseStack, this.inscribeButton.f_93620_, this.inscribeButton.f_93621_, 14, 185, 14, 14);
            }
        } else {
            this.m_93228_(poseStack, this.inscribeButton.f_93620_, this.inscribeButton.f_93621_, 0, 185, 14, 14);
        }
    }

    private void renderSpellSlot(PoseStack poseStack, Vec2 pos, int mouseX, int mouseY, int index, SpellSlotInfo slot) {
        boolean hovering = this.isHovering((int)pos.f_82470_, (int)pos.f_82471_, 19, 19, mouseX, mouseY);
        int iconToDraw = hovering ? 38 : (slot.hasSpell() ? 19 : 0);
        this.m_93228_(poseStack, (int)pos.f_82470_, (int)pos.f_82471_, iconToDraw, 166, 19, 19);
        if (slot.hasSpell()) {
            this.drawSpellIcon(poseStack, pos, slot);
            this.setTexture(TEXTURE);
            if (hovering && ((InscriptionTableMenu)this.f_97732_).getSpellBookSlot().m_7993_().m_41720_() instanceof UniqueSpellBook) {
                this.m_93228_(poseStack, (int)pos.f_82470_, (int)pos.f_82471_, 76, 166, 19, 19);
            }
        }
        if (index == this.selectedSpellIndex) {
            this.m_93228_(poseStack, (int)pos.f_82470_, (int)pos.f_82471_, 57, 166, 19, 19);
        }
    }

    private void drawSpellIcon(PoseStack poseStack, Vec2 pos, SpellSlotInfo slot) {
        this.setTexture(slot.containedSpell.getSpellType().getResourceLocation());
        InscriptionTableScreen.m_93133_((PoseStack)poseStack, (int)((int)pos.f_82470_ + 2), (int)((int)pos.f_82471_ + 2), (float)0.0f, (float)0.0f, (int)15, (int)15, (int)16, (int)16);
    }

    private void renderLorePage(PoseStack poseStack, float partialTick, int mouseX, int mouseY) {
        int x = this.f_97735_ + 176;
        int y = this.f_97736_;
        int margin = 5;
        Style textColor = Style.f_131099_.m_178520_(3288106);
        TranslatableComponent title = this.selectedSpellIndex < 0 ? io.redspace.ironsspellbooks.util.Component.translatable("ui.irons_spellbooks.no_selection", new Object[0]) : (this.spellSlots.get(this.selectedSpellIndex).hasSpell() ? this.spellSlots.get((int)this.selectedSpellIndex).containedSpell.getSpellType().getDisplayName() : io.redspace.ironsspellbooks.util.Component.translatable("ui.irons_spellbooks.empty_slot", new Object[0]));
        List titleLines = this.f_96547_.m_92923_((FormattedText)title.m_130940_(ChatFormatting.UNDERLINE).m_130948_(textColor), 80);
        int titleY = this.f_97736_ + 10;
        for (FormattedCharSequence line : titleLines) {
            int titleWidth = this.f_96547_.m_92724_(line);
            int titleX = x + (80 - titleWidth) / 2;
            this.f_96547_.m_92877_(poseStack, line, (float)titleX, (float)titleY, 0xFFFFFF);
            Objects.requireNonNull(this.f_96547_);
            titleY += 9;
        }
        int titleHeight = this.f_96547_.m_92920_(title.getString(), 80);
        int descLine = titleY + 4;
        if (this.selectedSpellIndex < 0 || !this.spellSlots.get(this.selectedSpellIndex).hasSpell()) {
            return;
        }
        Style colorMana = Style.f_131099_.m_178520_(17577);
        Style colorCast = Style.f_131099_.m_178520_(0x115511);
        Style colorCooldown = Style.f_131099_.m_178520_(0x115511);
        AbstractSpell spell = this.spellSlots.get((int)this.selectedSpellIndex).containedSpell;
        float textScale = 1.0f;
        float reverseScale = 1.0f / textScale;
        Component school = spell.getSchoolType().getDisplayName();
        poseStack.m_85841_(textScale, textScale, textScale);
        this.drawTextWithShadow(this.f_96547_, poseStack, school, x + (80 - this.f_96547_.m_92895_(school.getString())) / 2, descLine, 0xFFFFFF, 1.0f);
        float f = descLine;
        Objects.requireNonNull(this.f_96547_);
        descLine = (int)(f + 9.0f * textScale);
        MutableComponent levelText = io.redspace.ironsspellbooks.util.Component.translatable("ui.irons_spellbooks.level", spell.getLevel(null)).m_130948_(textColor);
        this.f_96547_.m_92889_(poseStack, (Component)levelText, (float)(x + (80 - this.f_96547_.m_92895_(levelText.getString())) / 2), (float)descLine, 0xFFFFFF);
        float f2 = descLine;
        Objects.requireNonNull(this.f_96547_);
        descLine = (int)(f2 + 9.0f * textScale * 2.0f);
        descLine += this.drawStatText(this.f_96547_, poseStack, x + margin, descLine, "ui.irons_spellbooks.mana_cost", textColor, (MutableComponent)io.redspace.ironsspellbooks.util.Component.translatable("" + spell.getManaCost(), new Object[0]), colorMana, textScale);
        descLine += this.drawText(this.f_96547_, poseStack, (Component)TooltipsUtils.getCastTimeComponent(spell.getCastType(), Utils.timeFromTicks(spell.getEffectiveCastTime(null), 1)), x + margin, descLine, textColor.m_131135_().m_131265_(), textScale);
        descLine += this.drawStatText(this.f_96547_, poseStack, x + margin, descLine, "ui.irons_spellbooks.cooldown", textColor, (MutableComponent)io.redspace.ironsspellbooks.util.Component.translatable(Utils.timeFromTicks(spell.getSpellCooldown(), 1), new Object[0]), colorCooldown, textScale);
        for (MutableComponent component : spell.getUniqueInfo(null)) {
            descLine += this.drawText(this.f_96547_, poseStack, (Component)component, x + margin, descLine, textColor.m_131135_().m_131265_(), 1.0f);
        }
        poseStack.m_85841_(reverseScale, reverseScale, reverseScale);
    }

    private void drawTextWithShadow(Font font, PoseStack poseStack, Component text, int x, int y, int color, float scale) {
        x = (int)((float)x / scale);
        y = (int)((float)y / scale);
        font.m_92889_(poseStack, text, (float)x, (float)y, color);
        font.m_92763_(poseStack, text, (float)x, (float)y, color);
    }

    private int drawText(Font font, PoseStack poseStack, Component text, int x, int y, int color, float scale) {
        x = (int)((float)x / scale);
        y = (int)((float)y / scale);
        font.m_92857_((FormattedText)text, x, y, 80, color);
        return font.m_92920_(text.getString(), 80);
    }

    private int drawStatText(Font font, PoseStack poseStack, int x, int y, String translationKey, Style textStyle, MutableComponent stat, Style statStyle, float scale) {
        return this.drawText(font, poseStack, (Component)io.redspace.ironsspellbooks.util.Component.translatable(translationKey, stat.m_130948_(statStyle)).m_130948_(textStyle), x, y, 0xFFFFFF, scale);
    }

    private void generateSpellSlots() {
        for (SpellSlotInfo s : this.spellSlots) {
            this.m_169411_((GuiEventListener)s.button);
        }
        this.spellSlots.clear();
        if (!this.isSpellBookSlotted()) {
            return;
        }
        Slot spellBookSlot = (Slot)((InscriptionTableMenu)this.f_97732_).f_38839_.get(36);
        ItemStack spellBookItemStack = spellBookSlot.m_7993_();
        SpellBookData spellBookData = SpellBookData.getSpellBookData(spellBookItemStack);
        AbstractSpell[] storedSpells = spellBookData.getInscribedSpells();
        int spellCount = spellBookData.getSpellSlots();
        if (spellCount > 15) {
            spellCount = 15;
        }
        if (spellCount <= 0) {
            return;
        }
        int boxSize = 19;
        int[] row1 = new int[this.LAYOUT[spellCount - 1][0]];
        int[] row2 = new int[this.LAYOUT[spellCount - 1][1]];
        int[] row3 = new int[this.LAYOUT[spellCount - 1][2]];
        int[] rowWidth = new int[]{boxSize * row1.length, boxSize * row2.length, boxSize * row3.length};
        int[] rowHeight = new int[]{row1.length > 0 ? boxSize : 0, row2.length > 0 ? boxSize : 0, row3.length > 0 ? boxSize : 0};
        int overallHeight = rowHeight[0] + rowHeight[1] + rowHeight[2];
        int[][] display = new int[][]{row1, row2, row3};
        int index = 0;
        for (int row = 0; row < display.length; ++row) {
            for (int column = 0; column < display[row].length; ++column) {
                int offset = -rowWidth[row] / 2;
                Vec2 location = new Vec2((float)(offset + column * boxSize), (float)(row * boxSize - overallHeight / 2));
                location.m_165908_(-9.0f);
                int temp_index = index;
                this.spellSlots.add(new SpellSlotInfo(storedSpells[index], location, (Button)this.m_7787_((GuiEventListener)new Button((int)location.f_82470_, (int)location.f_82471_, boxSize, boxSize, (Component)io.redspace.ironsspellbooks.util.Component.translatable("" + temp_index, new Object[0]), p_169820_ -> this.setSelectedIndex(temp_index)))));
                ++index;
            }
        }
        this.isDirty = false;
    }

    private void onSpellBookSlotChanged() {
        this.isDirty = true;
        ItemStack spellBookStack = ((Slot)((InscriptionTableMenu)this.f_97732_).f_38839_.get(36)).m_7993_();
        if (spellBookStack.m_41720_() instanceof SpellBook) {
            SpellBookData spellBookData = SpellBookData.getSpellBookData(spellBookStack);
            if (spellBookData.getSpellSlots() <= this.selectedSpellIndex) {
                this.resetSelectedSpell();
            }
        } else {
            this.resetSelectedSpell();
        }
    }

    private void onInscription() {
        Item item = ((InscriptionTableMenu)this.f_97732_).getSpellBookSlot().m_7993_().m_41720_();
        if (item instanceof SpellBook) {
            SpellBook spellBook = (SpellBook)item;
            item = ((InscriptionTableMenu)this.f_97732_).getScrollSlot().m_7993_().m_41720_();
            if (item instanceof Scroll) {
                Scroll scroll = (Scroll)item;
                if (this.spellSlots.size() <= 0) {
                    return;
                }
                SpellData scrollData = SpellData.getSpellData(((InscriptionTableMenu)this.f_97732_).getScrollSlot().m_7993_());
                if (spellBook.getRarity().compareRarity(scrollData.getSpell().getRarity()) < 0) {
                    return;
                }
                if (spellBook.isUnique()) {
                    return;
                }
                if (this.selectedSpellIndex < 0 || this.spellSlots.get(this.selectedSpellIndex).hasSpell()) {
                    for (int i = this.selectedSpellIndex + 1; i < this.spellSlots.size(); ++i) {
                        if (this.spellSlots.get(i).hasSpell()) continue;
                        this.setSelectedIndex(i);
                        break;
                    }
                }
                if (this.spellSlots.get(this.selectedSpellIndex).hasSpell()) {
                    return;
                }
                this.isDirty = true;
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12493_, (float)1.0f));
                this.f_96541_.f_91072_.m_105208_(((InscriptionTableMenu)this.f_97732_).f_38840_, -1);
            }
        }
    }

    private void setSelectedIndex(int index) {
        this.selectedSpellIndex = index;
        this.f_96541_.f_91072_.m_105208_(((InscriptionTableMenu)this.f_97732_).f_38840_, index);
    }

    private void resetSelectedSpell() {
        this.setSelectedIndex(-1);
    }

    private boolean isValidInscription() {
        return this.isSpellBookSlotted() && this.isScrollSlotted();
    }

    private boolean isValidExtraction() {
        return this.selectedSpellIndex >= 0 && this.spellSlots.get(this.selectedSpellIndex).hasSpell() && !((Slot)((InscriptionTableMenu)this.f_97732_).f_38839_.get(38)).m_6657_();
    }

    private boolean isSpellBookSlotted() {
        return ((Slot)((InscriptionTableMenu)this.f_97732_).f_38839_.get(36)).m_7993_().m_41720_() instanceof SpellBook;
    }

    private boolean isScrollSlotted() {
        return ((Slot)((InscriptionTableMenu)this.f_97732_).f_38839_.get(37)).m_6657_() && ((Slot)((InscriptionTableMenu)this.f_97732_).f_38839_.get(37)).m_7993_().m_41720_() instanceof Scroll;
    }

    private boolean isHovering(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseY >= y && mouseX < x + width && mouseY < y + height;
    }

    private void setTexture(ResourceLocation texture) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
    }

    private class SpellSlotInfo {
        public AbstractSpell containedSpell;
        public Vec2 relativePosition;
        public Button button;

        SpellSlotInfo(AbstractSpell containedSpell, Vec2 relativePosition, Button button) {
            this.containedSpell = containedSpell;
            this.relativePosition = relativePosition;
            this.button = button;
        }

        public boolean hasSpell() {
            return this.containedSpell != null;
        }
    }
}

