/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.gui.arcane_anvil;

import io.redspace.ironsspellbooks.capabilities.spell.SpellData;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.item.Scroll;
import io.redspace.ironsspellbooks.item.UpgradeOrbItem;
import io.redspace.ironsspellbooks.registries.BlockRegistry;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import io.redspace.ironsspellbooks.registries.MenuRegistry;
import io.redspace.ironsspellbooks.util.UpgradeUtils;
import io.redspace.ironsspellbooks.util.Utils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ArcaneAnvilMenu
extends ItemCombinerMenu {
    public ArcaneAnvilMenu(int pContainerId, Inventory inventory, ContainerLevelAccess containerLevelAccess) {
        super((MenuType)MenuRegistry.ARCANE_ANVIL_MENU.get(), pContainerId, inventory, containerLevelAccess);
    }

    public ArcaneAnvilMenu(int pContainerId, Inventory inventory, FriendlyByteBuf extraData) {
        this(pContainerId, inventory, ContainerLevelAccess.f_39287_);
    }

    protected boolean m_6560_(Player pPlayer, boolean pHasStack) {
        return true;
    }

    protected void m_142365_(Player p_150601_, ItemStack p_150602_) {
        this.f_39769_.m_8020_(0).m_41774_(1);
        this.f_39769_.m_8020_(1).m_41774_(1);
        this.f_39770_.m_39292_((level, pos) -> {
            level.m_5594_(null, pos, SoundEvents.f_11671_, SoundSource.BLOCKS, 0.8f, 1.1f);
            level.m_5594_(null, pos, SoundEvents.f_144242_, SoundSource.BLOCKS, 1.0f, 1.0f);
        });
    }

    protected boolean m_8039_(BlockState pState) {
        return pState.m_60713_((Block)BlockRegistry.ARCANE_ANVIL_BLOCK.get());
    }

    public void m_6640_() {
        ItemStack result = ItemStack.f_41583_;
        ItemStack baseItemStack = this.f_39769_.m_8020_(0);
        ItemStack modifierItemStack = this.f_39769_.m_8020_(1);
        if (!baseItemStack.m_41619_() && !modifierItemStack.m_41619_()) {
            Item scrollData2;
            if (baseItemStack.m_41720_() instanceof Scroll && modifierItemStack.m_41720_() instanceof Scroll) {
                SpellData scrollData1 = SpellData.getSpellData(baseItemStack);
                SpellData scrollData2 = SpellData.getSpellData(modifierItemStack);
                if (scrollData1.getSpellId() == scrollData2.getSpellId() && scrollData1.getLevel() == scrollData2.getLevel() && scrollData1.getLevel() < ServerConfigs.getSpellConfig(scrollData1.getSpellId()).maxLevel()) {
                    result = new ItemStack((ItemLike)ItemRegistry.SCROLL.get());
                    SpellData.setSpellData(result, scrollData1.getSpellId(), scrollData1.getLevel() + 1);
                }
            } else if (Utils.canImbue(baseItemStack) && modifierItemStack.m_41720_() instanceof Scroll) {
                result = baseItemStack.m_41777_();
                SpellData scrollData2 = SpellData.getSpellData(modifierItemStack);
                SpellData.setSpellData(result, scrollData2.getSpell());
            } else if (Utils.canBeUpgraded(baseItemStack) && UpgradeUtils.getUpgradeCount(baseItemStack) < (Integer)ServerConfigs.MAX_UPGRADES.get() && (scrollData2 = modifierItemStack.m_41720_()) instanceof UpgradeOrbItem) {
                UpgradeOrbItem upgradeOrb = (UpgradeOrbItem)scrollData2;
                result = baseItemStack.m_41777_();
                EquipmentSlot slot = UpgradeUtils.getAssignedEquipmentSlot(result);
                UpgradeUtils.appendUpgrade(result, upgradeOrb.getUpgradeType(), slot);
            }
        }
        this.f_39768_.m_6836_(0, result);
    }

    public boolean m_5882_(ItemStack pStack, Slot pSlot) {
        return pSlot.f_40218_ != this.f_39768_ && super.m_5882_(pStack, pSlot);
    }
}

