/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.spells.void_tentacle;

import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import io.redspace.ironsspellbooks.registries.EntityRegistry;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.Collections;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class VoidTentacle
extends LivingEntity
implements IAnimatable,
AntiMagicSusceptible {
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;
    private float damage;
    private int age;
    private final AnimationBuilder ANIMATION_RISE = new AnimationBuilder().addAnimation("rise", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    private final AnimationBuilder ANIMATION_RETREAT = new AnimationBuilder().addAnimation("retreat", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME);
    private final AnimationBuilder ANIMATION_FLAIL = new AnimationBuilder().addAnimation("flail", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    private final AnimationBuilder ANIMATION_FLAIL2 = new AnimationBuilder().addAnimation("flail2", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    private final AnimationBuilder ANIMATION_FLAIL3 = new AnimationBuilder().addAnimation("flail3", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    private final AnimationController controller = new AnimationController((IAnimatable)this, "void_tentacle_controller", 20.0f, this::animationPredicate);
    private final AnimationController riseController = new AnimationController((IAnimatable)this, "void_tentacle_rise_controller", 0.0f, this::risePredicate);
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public VoidTentacle(EntityType<? extends VoidTentacle> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public VoidTentacle(Level level, LivingEntity owner, float damage) {
        this((EntityType<? extends VoidTentacle>)((EntityType)EntityRegistry.VOID_TENTACLE.get()), level);
        this.setOwner(owner);
        this.setDamage(damage);
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            if (this.age > 300) {
                this.m_146870_();
            } else if (this.age < 280 && this.age % 20 == 0) {
                this.f_19853_.m_45976_(LivingEntity.class, this.m_142469_().m_82400_(1.2)).forEach(this::dealDamage);
                if (this.f_19853_.f_46441_.nextFloat() < 0.15f) {
                    this.m_5496_((SoundEvent)SoundRegistry.VOID_TENTACLES_AMBIENT.get(), 1.5f, 0.5f + this.f_19853_.f_46441_.nextFloat() * 0.65f);
                }
            }
            if (this.age == 260 && this.f_19853_.f_46441_.nextFloat() < 0.3f) {
                this.m_5496_((SoundEvent)SoundRegistry.VOID_TENTACLES_LEAVE.get(), 1.0f, 1.0f);
            }
        } else if (this.age < 280 && this.f_19853_.f_46441_.nextFloat() < 0.15f) {
            this.f_19853_.m_7106_(ParticleHelper.VOID_TENTACLE_FOG, this.m_20185_() + Utils.getRandomScaled(0.5), this.m_20186_() + Utils.getRandomScaled(0.5) + (double)0.2f, this.m_20189_() + Utils.getRandomScaled(0.5), Utils.getRandomScaled(2.0), (double)(-this.f_19796_.nextFloat() * 0.5f), Utils.getRandomScaled(2.0));
        }
        ++this.age;
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public boolean dealDamage(LivingEntity target) {
        if (target != this.getOwner() && DamageSources.applyDamage((Entity)target, this.damage, SpellType.VOID_TENTACLES_SPELL.getDamageSource((Entity)this, (Entity)this.getOwner()), SchoolType.ENDER)) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100));
            return true;
        }
        return false;
    }

    public void setOwner(@Nullable LivingEntity pOwner) {
        this.owner = pOwner;
        this.ownerUUID = pOwner == null ? null : pOwner.m_142081_();
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (!pSource.m_19378_()) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.f_19853_ instanceof ServerLevel && (entity = ((ServerLevel)this.f_19853_).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.age = pCompound.m_128451_("Age");
        if (pCompound.m_128403_("Owner")) {
            this.ownerUUID = pCompound.m_128342_("Owner");
        }
    }

    public Iterable<ItemStack> m_6168_() {
        return Collections.singleton(ItemStack.f_41583_);
    }

    public ItemStack m_6844_(EquipmentSlot pSlot) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot pSlot, ItemStack pStack) {
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Age", this.age);
        if (this.ownerUUID != null) {
            pCompound.m_128362_("Owner", this.ownerUUID);
        }
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    @Override
    public void onAntiMagic(PlayerMagicData playerMagicData) {
        MagicManager.spawnParticles(this.f_19853_, (ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 50, 0.2, 1.25, 0.2, 0.08, false);
        this.m_146870_();
    }

    private PlayState animationPredicate(AnimationEvent event) {
        AnimationController controller = event.getController();
        if (this.age > 250 && this.f_19853_.f_46441_.nextFloat() < 0.04f) {
            controller.setAnimation(this.ANIMATION_RETREAT);
        } else if (controller.getAnimationState() == AnimationState.Stopped) {
            controller.setAnimationSpeed((double)((2.0f + this.f_19853_.f_46441_.nextFloat()) / 2.0f));
            int animation = this.f_19796_.nextInt(3);
            switch (animation) {
                case 0: {
                    controller.setAnimation(this.ANIMATION_FLAIL);
                    break;
                }
                case 1: {
                    controller.setAnimation(this.ANIMATION_FLAIL2);
                    break;
                }
                case 2: {
                    controller.setAnimation(this.ANIMATION_FLAIL3);
                }
            }
        }
        return PlayState.CONTINUE;
    }

    private PlayState risePredicate(AnimationEvent event) {
        AnimationController controller = event.getController();
        if (this.age < 10) {
            controller.setAnimation(this.ANIMATION_RISE);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(this.riseController);
        data.addAnimationController(this.controller);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

