/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.spells.target_area;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import io.redspace.ironsspellbooks.entity.spells.target_area.TargetedAreaEntity;
import io.redspace.ironsspellbooks.render.SpellTargetingLayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class TargetAreaRenderer
extends EntityRenderer<TargetedAreaEntity> {
    public TargetAreaRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public ResourceLocation getTextureLocation(TargetedAreaEntity pEntity) {
        return null;
    }

    public void render(TargetedAreaEntity entity, float pEntityYaw, float pPartialTick, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110436_((ResourceLocation)SpellTargetingLayer.TEXTURE, (float)0.0f, (float)0.0f));
        Vector3f color = entity.getColor();
        poseStack.m_85836_();
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f poseMatrix = pose.m_85861_();
        Matrix3f normalMatrix = pose.m_85864_();
        float radius = entity.getRadius();
        float correction = 0.05f / radius;
        float circumference = (2.0f + correction) * radius * (float)Math.PI;
        int segments = (int)(3.0f * radius + 9.0f);
        float angle = 360.0f / (float)segments;
        float segmentWidth = circumference / (float)segments;
        for (int i = 0; i < segments; ++i) {
            TargetAreaRenderer.drawPlane(consumer, color, poseMatrix, normalMatrix, light, segmentWidth, radius);
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(angle));
        }
        poseStack.m_85849_();
    }

    private static void drawPlane(VertexConsumer consumer, Vector3f color, Matrix4f poseMatrix, Matrix3f normalMatrix, int light, float width, float radius) {
        float halfWidth = width * 0.5f;
        consumer.m_85982_(poseMatrix, halfWidth, 0.0f, radius).m_85950_(color.m_122239_(), color.m_122260_(), color.m_122269_(), 1.0f).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light * 4).m_85977_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_85982_(poseMatrix, halfWidth, 1.0f, radius).m_85950_(color.m_122239_(), color.m_122260_(), color.m_122269_(), 1.0f).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light * 4).m_85977_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_85982_(poseMatrix, -halfWidth, 1.0f, radius).m_85950_(color.m_122239_(), color.m_122260_(), color.m_122269_(), 1.0f).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light * 4).m_85977_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_85982_(poseMatrix, -halfWidth, 0.0f, radius).m_85950_(color.m_122239_(), color.m_122260_(), color.m_122269_(), 1.0f).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light * 4).m_85977_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

