/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.spells.poison_arrow;

import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.spells.AbstractMagicProjectile;
import io.redspace.ironsspellbooks.entity.spells.poison_cloud.PoisonCloud;
import io.redspace.ironsspellbooks.registries.EntityRegistry;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class PoisonArrow
extends AbstractMagicProjectile {
    private static final EntityDataAccessor<Boolean> IN_GROUND = SynchedEntityData.m_135353_(PoisonArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int shakeTime;
    protected boolean hasEmittedPoison;
    protected boolean inGround;
    protected float aoeDamage;

    public PoisonArrow(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public PoisonArrow(Level levelIn, LivingEntity shooter) {
        this((EntityType<? extends Projectile>)((EntityType)EntityRegistry.POISON_ARROW.get()), levelIn);
        this.m_5602_((Entity)shooter);
    }

    @Override
    public void m_8119_() {
        if (this.shakeTime > 0) {
            --this.shakeTime;
        }
        if (!this.inGround) {
            super.m_8119_();
        } else {
            if (++this.age > 300) {
                this.m_146870_();
                return;
            }
            if (this.shouldFall()) {
                this.inGround = false;
                this.m_20256_(this.m_20184_().m_82541_().m_82490_((double)0.05f));
            }
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(IN_GROUND, (Object)false);
    }

    public void setAoeDamage(float damage) {
        this.aoeDamage = damage;
    }

    public float getAoeDamage() {
        return this.aoeDamage;
    }

    private boolean shouldFall() {
        return this.inGround && this.f_19853_.m_45772_(new AABB(this.m_20182_(), this.m_20182_()).m_82400_(0.06));
    }

    protected void m_8060_(BlockHitResult pResult) {
        super.m_8060_(pResult);
        Vec3 vec3 = pResult.m_82450_().m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_20256_(vec3);
        Vec3 vec31 = vec3.m_82541_().m_82490_((double)0.05f);
        this.m_20343_(this.m_20185_() - vec31.f_82479_, this.m_20186_() - vec31.f_82480_, this.m_20189_() - vec31.f_82481_);
        this.m_5496_(SoundEvents.f_11685_, 1.0f, 1.2f / (this.f_19796_.nextFloat() * 0.2f + 0.9f));
        this.inGround = true;
        this.shakeTime = 7;
        if (!this.f_19853_.f_46443_ && !this.hasEmittedPoison) {
            this.createPoisonCloud(pResult.m_82450_());
        }
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        boolean ignore;
        if (this.f_19853_.f_46443_) {
            return;
        }
        Entity entity = entityHitResult.m_82443_();
        boolean hit = DamageSources.applyDamage(entity, this.getDamage(), SpellType.POISON_ARROW_SPELL.getDamageSource((Entity)this, this.m_37282_()), SchoolType.POISON);
        boolean bl = ignore = entity.m_6095_() == EntityType.f_20566_;
        if (hit) {
            if (!ignore) {
                if (!this.f_19853_.f_46443_ && !this.hasEmittedPoison) {
                    this.createPoisonCloud(entity.m_20182_());
                }
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    livingEntity.m_21317_(livingEntity.m_21234_() + 1);
                }
                Vec3 spawn = entityHitResult.m_82450_();
                this.m_146870_();
            }
        } else {
            this.m_20256_(this.m_20184_().m_82490_(-0.1));
            this.m_146922_(this.m_146908_() + 180.0f);
            this.f_19859_ += 180.0f;
        }
    }

    @Override
    protected void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("inGround", this.inGround);
        pCompound.m_128379_("hasEmittedPoison", this.hasEmittedPoison);
        pCompound.m_128350_("aoeDamage", this.aoeDamage);
    }

    public void createPoisonCloud(Vec3 location) {
        if (!this.f_19853_.f_46443_) {
            PoisonCloud cloud = new PoisonCloud(this.f_19853_);
            cloud.m_5602_(this.m_37282_());
            cloud.setDuration(200);
            cloud.setDamage(this.aoeDamage);
            cloud.m_20219_(location);
            this.f_19853_.m_7967_((Entity)cloud);
            this.hasEmittedPoison = true;
        }
    }

    @Override
    protected void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.inGround = pCompound.m_128471_("inGround");
        this.hasEmittedPoison = pCompound.m_128471_("hasEmittedPoison");
        this.aoeDamage = pCompound.m_128457_("aoeDamage");
    }

    @Override
    public void trailParticles() {
        Vec3 vec3 = this.m_20182_().m_82546_(this.m_20184_().m_82490_(2.0));
        this.f_19853_.m_7106_(ParticleHelper.ACID, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0.0, 0.0, 0.0);
    }

    @Override
    public void impactParticles(double x, double y, double z) {
        MagicManager.spawnParticles(this.f_19853_, ParticleHelper.ACID, x, y, z, 15, 0.03, 0.03, 0.03, 0.2, true);
    }

    @Override
    public float getSpeed() {
        return 2.5f;
    }

    @Override
    public Optional<SoundEvent> getImpactSound() {
        return Optional.empty();
    }

    @Override
    public boolean respectsGravity() {
        return true;
    }
}

