/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.spells.magic_missile;

import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.spells.AbstractMagicProjectile;
import io.redspace.ironsspellbooks.registries.EntityRegistry;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.Optional;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class MagicMissileProjectile
extends AbstractMagicProjectile {
    public MagicMissileProjectile(EntityType<? extends MagicMissileProjectile> entityType, Level level) {
        super(entityType, level);
        this.m_20242_(true);
    }

    public MagicMissileProjectile(EntityType<? extends MagicMissileProjectile> entityType, Level levelIn, LivingEntity shooter) {
        super(entityType, levelIn);
        this.m_5602_((Entity)shooter);
    }

    public MagicMissileProjectile(Level levelIn, LivingEntity shooter) {
        this((EntityType<? extends MagicMissileProjectile>)((EntityType)EntityRegistry.MAGIC_MISSILE_PROJECTILE.get()), levelIn, shooter);
    }

    @Override
    public void impactParticles(double x, double y, double z) {
        MagicManager.spawnParticles(this.f_19853_, ParticleHelper.UNSTABLE_ENDER, x, y, z, 25, 0.0, 0.0, 0.0, 0.18, true);
    }

    @Override
    public float getSpeed() {
        return 3.0f;
    }

    @Override
    public Optional<SoundEvent> getImpactSound() {
        return Optional.empty();
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        this.m_6074_();
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        if (DamageSources.applyDamage(entityHitResult.m_82443_(), this.damage, SpellType.MAGIC_MISSILE_SPELL.getDamageSource((Entity)this, this.m_37282_()), SchoolType.ENDER)) {
            this.m_6074_();
        }
    }

    @Override
    public void trailParticles() {
        for (int i = 0; i < 2; ++i) {
            double speed = 0.02;
            double dx = this.f_19853_.f_46441_.nextDouble() * 2.0 * speed - speed;
            double dy = this.f_19853_.f_46441_.nextDouble() * 2.0 * speed - speed;
            double dz = this.f_19853_.f_46441_.nextDouble() * 2.0 * speed - speed;
            this.f_19853_.m_7106_(ParticleHelper.UNSTABLE_ENDER, this.m_20185_() + dx, this.m_20186_() + dy, this.m_20189_() + dz, dx, dy, dz);
            if (this.age <= 1) continue;
            this.f_19853_.m_7106_(ParticleHelper.UNSTABLE_ENDER, this.m_20185_() + dx - this.m_20184_().f_82479_ / 2.0, this.m_20186_() + dy - this.m_20184_().f_82480_ / 2.0, this.m_20189_() + dz - this.m_20184_().f_82481_ / 2.0, dx, dy, dz);
        }
    }
}

