/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.spells.fireball;

import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.spells.AbstractMagicProjectile;
import io.redspace.ironsspellbooks.registries.EntityRegistry;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class SmallMagicFireball
extends AbstractMagicProjectile
implements ItemSupplier {
    public SmallMagicFireball(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public SmallMagicFireball(Level pLevel, LivingEntity pShooter) {
        this((EntityType<? extends Projectile>)((EntityType)EntityRegistry.SMALL_FIREBALL_PROJECTILE.get()), pLevel);
        this.m_5602_((Entity)pShooter);
    }

    public void shoot(Vec3 rotation, float innaccuracy) {
        Vec3 offset = Utils.getRandomVec3(1.0).m_82541_().m_82490_((double)innaccuracy);
        super.shoot(rotation.m_82549_(offset));
    }

    @Override
    public void trailParticles() {
        Vec3 vec3 = this.m_20184_();
        double d0 = this.m_20185_() - vec3.f_82479_;
        double d1 = this.m_20186_() - vec3.f_82480_;
        double d2 = this.m_20189_() - vec3.f_82481_;
        for (int i = 0; i < 2; ++i) {
            Vec3 random = Utils.getRandomVec3(0.1);
            this.f_19853_.m_7106_(ParticleHelper.EMBERS, d0 - random.f_82479_, d1 + 0.5 - random.f_82480_, d2 - random.f_82481_, random.f_82479_ * 0.5, random.f_82480_ * 0.5, random.f_82481_ * 0.5);
        }
    }

    @Override
    public void impactParticles(double x, double y, double z) {
    }

    @Override
    public float getSpeed() {
        return 1.85f;
    }

    @Override
    public Optional<SoundEvent> getImpactSound() {
        return Optional.empty();
    }

    protected void m_5790_(EntityHitResult pResult) {
        Entity owner;
        Entity target;
        if (!this.f_19853_.f_46443_ && DamageSources.applyDamage(target = pResult.m_82443_(), this.damage, SpellType.BLAZE_STORM_SPELL.getDamageSource((Entity)this, owner = this.m_37282_()), SchoolType.FIRE)) {
            target.m_20254_(5);
        }
    }

    protected void m_8060_(BlockHitResult pResult) {
        BlockPos blockpos;
        Entity entity;
        super.m_8060_(pResult);
        if (!this.f_19853_.f_46443_ && (!((entity = this.m_37282_()) instanceof Mob) || ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)entity)) && this.f_19853_.m_46859_(blockpos = pResult.m_82425_().m_142300_(pResult.m_82434_()))) {
            this.f_19853_.m_46597_(blockpos, BaseFireBlock.m_49245_((BlockGetter)this.f_19853_, (BlockPos)blockpos));
        }
    }

    @Override
    protected void m_6532_(HitResult pResult) {
        super.m_6532_(pResult);
        if (!this.f_19853_.f_46443_) {
            this.m_146870_();
        }
    }

    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)Items.f_42613_);
    }
}

