/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.spells.fireball;

import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.spells.AbstractMagicProjectile;
import io.redspace.ironsspellbooks.registries.EntityRegistry;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class MagicFireball
extends AbstractMagicProjectile
implements ItemSupplier {
    public MagicFireball(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public MagicFireball(Level pLevel, LivingEntity pShooter) {
        this((EntityType<? extends Projectile>)((EntityType)EntityRegistry.MAGIC_FIREBALL.get()), pLevel);
        this.m_5602_((Entity)pShooter);
    }

    @Override
    public void trailParticles() {
        Vec3 vec3 = this.m_20184_();
        double d0 = this.m_20185_() - vec3.f_82479_;
        double d1 = this.m_20186_() - vec3.f_82480_;
        double d2 = this.m_20189_() - vec3.f_82481_;
        for (int i = 0; i < 8; ++i) {
            Vec3 motion = Utils.getRandomVec3(0.1).m_82546_(this.m_20184_().m_82490_((double)0.1f));
            Vec3 pos = Utils.getRandomVec3(0.3);
            this.f_19853_.m_7106_(ParticleHelper.EMBERS, d0 + pos.f_82479_, d1 + 0.5 + pos.f_82480_, d2 + pos.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
        }
    }

    @Override
    public void impactParticles(double x, double y, double z) {
    }

    @Override
    public float getSpeed() {
        return 1.15f;
    }

    @Override
    public Optional<SoundEvent> getImpactSound() {
        return Optional.of(SoundEvents.f_11913_);
    }

    @Override
    protected void m_6532_(HitResult hitResult) {
        if (!this.f_19853_.f_46443_) {
            this.impactParticles(this.f_19790_, this.f_19791_, this.f_19792_);
            float explosionRadius = this.getExplosionRadius();
            List entities = this.f_19853_.m_45933_((Entity)this, this.m_142469_().m_82400_((double)explosionRadius));
            for (Entity entity : entities) {
                double distance = entity.m_20238_(hitResult.m_82450_());
                if (!(distance < (double)(explosionRadius * explosionRadius)) || !this.m_5603_(entity)) continue;
                double p = 1.0 - Math.pow(Math.sqrt(distance) / (double)explosionRadius, 3.0);
                float damage = (float)((double)this.damage * p);
                DamageSources.applyDamage(entity, damage, SpellType.FIREBALL_SPELL.getDamageSource((Entity)this, this.m_37282_()), SchoolType.FIRE);
            }
            boolean flag = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this.m_37282_());
            this.f_19853_.m_7703_(null, SpellType.FIREBALL_SPELL.getDamageSource((Entity)this, this.m_37282_()), null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getExplosionRadius(), flag, flag ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE);
            this.m_146870_();
        }
    }

    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)Items.f_42613_);
    }
}

