/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.spells.black_hole;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.entity.spells.black_hole.BlackHole;
import io.redspace.ironsspellbooks.entity.spells.icicle.IcicleRenderer;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class BlackHoleRenderer
extends EntityRenderer<BlackHole> {
    private static final ResourceLocation CENTER_TEXTURE = IronsSpellbooks.id("textures/entity/black_hole/black_hole.png");
    private static final ResourceLocation BEAM_TEXTURE = IronsSpellbooks.id("textures/entity/black_hole/beam.png");
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);

    public BlackHoleRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public void render(BlackHole entity, float pEntityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int pPackedLight) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, entity.m_142469_().m_82376_() / 2.0, 0.0);
        float entityScale = entity.m_20205_() * 0.025f;
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f poseMatrix = pose.m_85861_();
        Matrix3f normalMatrix = pose.m_85864_();
        poseStack.m_85841_(0.5f * entityScale, 0.5f * entityScale, 0.5f * entityScale);
        poseStack.m_85845_(this.f_114476_.m_114470_());
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        poseStack.m_85837_(1.0, 0.0, 0.0);
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)CENTER_TEXTURE));
        consumer.m_85982_(poseMatrix, 0.0f, -8.0f, -8.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_85977_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_85982_(poseMatrix, 0.0f, 8.0f, -8.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_85977_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_85982_(poseMatrix, 0.0f, 8.0f, 8.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_85977_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_85982_(poseMatrix, 0.0f, -8.0f, 8.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_85977_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        poseStack.m_85849_();
        poseStack.m_85836_();
        if (Minecraft.m_91087_().f_91074_ != null) {
            Vec3 backwards = Minecraft.m_91087_().f_91074_.m_20182_().m_82546_(entity.m_20318_(partialTicks)).m_82541_().m_82490_(-2.0);
            poseStack.m_85837_(backwards.f_82479_, backwards.f_82480_, backwards.f_82481_);
        }
        poseStack.m_85837_(0.0, entity.m_142469_().m_82376_() / 2.0, 0.0);
        float animationProgress = ((float)entity.f_19797_ + partialTicks) / 200.0f;
        float fadeProgress = 0.5f;
        Random random = new Random(432L);
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110436_((ResourceLocation)BEAM_TEXTURE, (float)0.0f, (float)0.0f));
        float segments = Math.min(animationProgress, 0.8f);
        int i = 0;
        while ((float)i < (segments + segments * segments) / 2.0f * 60.0f) {
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(random.nextFloat() * 360.0f));
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(random.nextFloat() * 360.0f));
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(random.nextFloat() * 360.0f));
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(random.nextFloat() * 360.0f));
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(random.nextFloat() * 360.0f));
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(random.nextFloat() * 360.0f + animationProgress * 90.0f));
            float size1 = (random.nextFloat() * 10.0f + 5.0f + fadeProgress * 5.0f) * entityScale * 0.4f;
            Matrix4f matrix = poseStack.m_85850_().m_85861_();
            Matrix3f normalMatrix2 = poseStack.m_85850_().m_85864_();
            int alpha = (int)(255.0f * (1.0f - fadeProgress));
            BlackHoleRenderer.drawTriangle(vertexConsumer, matrix, normalMatrix2, size1);
            ++i;
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, pEntityYaw, partialTicks, poseStack, bufferSource, pPackedLight);
    }

    public ResourceLocation getTextureLocation(BlackHole pEntity) {
        return IcicleRenderer.TEXTURE;
    }

    private static void vertex01(VertexConsumer p_114220_, Matrix4f p_114221_, int p_114222_) {
        p_114220_.m_85982_(p_114221_, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, p_114222_).m_5752_();
    }

    private static void vertex2(VertexConsumer p_114215_, Matrix4f p_114216_, float p_114217_, float p_114218_) {
        p_114215_.m_85982_(p_114216_, -HALF_SQRT_3 * p_114218_, p_114217_, -0.5f * p_114218_).m_6122_(255, 0, 255, 0).m_5752_();
    }

    private static void vertex3(VertexConsumer p_114224_, Matrix4f p_114225_, float p_114226_, float p_114227_) {
        p_114224_.m_85982_(p_114225_, HALF_SQRT_3 * p_114227_, p_114226_, -0.5f * p_114227_).m_6122_(255, 0, 255, 0).m_5752_();
    }

    private static void vertex4(VertexConsumer p_114229_, Matrix4f p_114230_, float p_114231_, float p_114232_) {
        p_114229_.m_85982_(p_114230_, 0.0f, p_114231_, 1.0f * p_114232_).m_6122_(255, 0, 255, 0).m_5752_();
    }

    private static void drawTriangle(VertexConsumer consumer, Matrix4f poseMatrix, Matrix3f normalMatrix, float size) {
        consumer.m_85982_(poseMatrix, 0.0f, 0.0f, 0.0f).m_6122_(255, 0, 255, 255).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_85977_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_85982_(poseMatrix, 0.0f, 3.0f * size, -1.0f * size).m_6122_(0, 0, 0, 0).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_85977_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_85982_(poseMatrix, 0.0f, 3.0f * size, 1.0f * size).m_6122_(0, 0, 0, 0).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_85977_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_85982_(poseMatrix, 0.0f, 0.0f, 0.0f).m_6122_(255, 0, 255, 255).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_85977_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

