/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.spells;

import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import io.redspace.ironsspellbooks.registries.EntityRegistry;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellType;
import java.util.List;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class ExtendedWitherSkull
extends WitherSkull
implements AntiMagicSusceptible {
    protected float damage;

    public ExtendedWitherSkull(EntityType<? extends WitherSkull> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public ExtendedWitherSkull(LivingEntity shooter, Level level, float speed, float damage) {
        super((EntityType)EntityRegistry.WITHER_SKULL_PROJECTILE.get(), level);
        this.m_5602_((Entity)shooter);
        Vec3 power = shooter.m_20154_().m_82541_().m_82490_((double)speed);
        this.f_36813_ = power.f_82479_;
        this.f_36814_ = power.f_82480_;
        this.f_36815_ = power.f_82481_;
        this.damage = damage;
    }

    protected void m_5790_(EntityHitResult pResult) {
        Entity entity = pResult.m_82443_();
        DamageSources.applyDamage(entity, this.damage, SpellType.WITHER_SKULL_SPELL.getDamageSource((Entity)this, this.m_37282_()), SchoolType.BLOOD);
    }

    protected void m_6532_(HitResult hitResult) {
        if (!this.f_19853_.f_46443_) {
            float explosionRadius = 2.0f;
            List entities = this.f_19853_.m_45933_((Entity)this, this.m_142469_().m_82400_((double)explosionRadius));
            for (Entity entity : entities) {
                double distance = entity.m_20238_(hitResult.m_82450_());
                if (!(distance < (double)(explosionRadius * explosionRadius)) || !this.m_5603_(entity)) continue;
                float damage = (float)((double)this.damage * (1.0 - distance / (double)(explosionRadius * explosionRadius)));
                DamageSources.applyDamage(entity, damage, SpellType.WITHER_SKULL_SPELL.getDamageSource((Entity)this, this.m_37282_()), SchoolType.BLOOD);
            }
            this.f_19853_.m_46518_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, false, Explosion.BlockInteraction.NONE);
            this.m_146870_();
        }
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    public void onAntiMagic(PlayerMagicData playerMagicData) {
        this.m_146870_();
    }
}

