/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.spells;

import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ExtendedFireworkRocket
extends FireworkRocketEntity
implements AntiMagicSusceptible {
    protected static final EntityDataAccessor<ItemStack> DATA_ID_FIREWORKS_ITEM = SynchedEntityData.m_135353_(ExtendedFireworkRocket.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private final float damage;

    public ExtendedFireworkRocket(Level pLevel, ItemStack pStack, Entity pShooter, double pX, double pY, double pZ, boolean pShotAtAngle, float damage) {
        super(pLevel, pStack, pShooter, pX, pY, pZ, pShotAtAngle);
        this.damage = damage;
    }

    public float getDamage() {
        return this.damage;
    }

    public void m_8119_() {
        if (!this.f_19853_.f_46443_) {
            this.explode();
        }
    }

    private void explode() {
        this.f_19853_.m_7605_((Entity)this, (byte)17);
        this.m_146852_(GameEvent.f_157812_, this.m_37282_());
        this.dealExplosionDamage();
        this.m_146870_();
    }

    private void dealExplosionDamage() {
        Vec3 pos = this.m_20182_();
        boolean los = false;
        double explosionRadius = 2.0;
        for (LivingEntity livingentity : this.f_19853_.m_45976_(LivingEntity.class, this.m_142469_().m_82400_(explosionRadius))) {
            if (!(this.m_20280_((Entity)livingentity) <= explosionRadius * explosionRadius) || !this.m_5603_((Entity)livingentity)) continue;
            for (int i = 0; i < 2; ++i) {
                Vec3 targetPos = new Vec3(livingentity.m_20185_(), livingentity.m_20227_(0.5 * (double)i), livingentity.m_20189_());
                BlockHitResult hitresult = this.f_19853_.m_45547_(new ClipContext(pos, targetPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
                if (hitresult.m_6662_() != HitResult.Type.MISS) continue;
                los = true;
                break;
            }
            if (!los) continue;
            DamageSources.applyDamage((Entity)livingentity, this.getDamage(), SpellType.FIRECRACKER_SPELL.getDamageSource((Entity)this, this.m_37282_()), SchoolType.EVOCATION);
        }
    }

    @Override
    public void onAntiMagic(PlayerMagicData playerMagicData) {
        this.m_146870_();
    }
}

