/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.mobs.keeper;

import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.entity.mobs.keeper.KeeperAnimatedWarlockAttackGoal;
import io.redspace.ironsspellbooks.registries.EntityRegistry;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class KeeperEntity
extends AbstractSpellCastingMob
implements Enemy {
    private static final EntityDataAccessor<Integer> DATA_ATTACK_TYPE = SynchedEntityData.m_135353_(KeeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimationBuilder doubleSlash = new AnimationBuilder().addAnimation("sword_double_slash", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    private final AnimationBuilder lunge = new AnimationBuilder().addAnimation("sword_lunge", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    private final AnimationBuilder slashStab = new AnimationBuilder().addAnimation("sword_slash_stab", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    private final AnimationBuilder tripleSlash = new AnimationBuilder().addAnimation("sword_triple_slash", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    private final AnimationController meleeController = new AnimationController((IAnimatable)this, "keeper_animations", 2.0f, this::predicate);

    public KeeperEntity(EntityType<? extends AbstractSpellCastingMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 25;
        this.f_19793_ = 1.0f;
    }

    public KeeperEntity(Level pLevel) {
        this((EntityType<? extends AbstractSpellCastingMob>)((EntityType)EntityRegistry.KEEPER.get()), pLevel);
    }

    public AttackType getNextAttackType() {
        return AttackType.values()[(Integer)this.f_19804_.m_135370_(DATA_ATTACK_TYPE)];
    }

    public void setNextAttackType(AttackType attackType) {
        this.f_19804_.m_135381_(DATA_ATTACK_TYPE, (Object)attackType.ordinal());
    }

    public void randomizeNextAttack() {
        this.f_19804_.m_135381_(DATA_ATTACK_TYPE, (Object)this.f_19796_.nextInt(AttackType.values().length));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ATTACK_TYPE, (Object)0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new KeeperAnimatedWarlockAttackGoal(this, 1.0, 10, 30, 3.5f));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, true, entity -> !(entity instanceof KeeperEntity)));
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12423_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12381_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12424_;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12383_;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.m_6851_(pDifficulty);
        return pSpawnData;
    }

    protected void m_6851_(DifficultyInstance pDifficulty) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_));
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22278_, 0.8).m_22268_(Attributes.f_22282_, 2.0).m_22268_(Attributes.f_22279_, 0.185);
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6673_(DamageSource pSource) {
        return super.m_6673_(pSource) || pSource.m_146707_();
    }

    private PlayState predicate(AnimationEvent animationEvent) {
        AnimationController controller = animationEvent.getController();
        if (this.f_20911_) {
            controller.markNeedsReload();
            switch (this.getNextAttackType()) {
                case Double_Slash: {
                    controller.setAnimation(this.doubleSlash);
                    break;
                }
                case Lunge: {
                    controller.setAnimation(this.lunge);
                    break;
                }
                case Slash_Stab: {
                    controller.setAnimation(this.slashStab);
                    break;
                }
                case Triple_Slash: {
                    controller.setAnimation(this.tripleSlash);
                }
            }
            this.f_20911_ = false;
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    @Override
    public void registerControllers(AnimationData data) {
        data.addAnimationController(this.meleeController);
        super.registerControllers(data);
    }

    @Override
    public boolean isAnimating() {
        return this.meleeController.getAnimationState() != AnimationState.Stopped || super.isAnimating();
    }

    @Override
    public boolean shouldAlwaysAnimateLegs() {
        return false;
    }

    @Override
    public boolean shouldBeExtraAnimated() {
        return true;
    }

    public static enum AttackType {
        Double_Slash,
        Lunge,
        Slash_Stab,
        Triple_Slash;

    }
}

