/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.mobs.keeper;

import io.redspace.ironsspellbooks.entity.mobs.goals.AttackAnimationData;
import io.redspace.ironsspellbooks.entity.mobs.goals.WarlockAttackGoal;
import io.redspace.ironsspellbooks.entity.mobs.keeper.KeeperEntity;
import java.util.Map;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class KeeperAnimatedWarlockAttackGoal
extends WarlockAttackGoal {
    final KeeperEntity keeper;
    int meleeAnimTimer = -1;
    public KeeperEntity.AttackType currentAttack;
    private boolean hasLunged;
    private boolean hasHitLunge;
    Map<KeeperEntity.AttackType, AttackAnimationData> attackAnimations = Map.of(KeeperEntity.AttackType.Double_Slash, new AttackAnimationData(28, 12, 21), KeeperEntity.AttackType.Lunge, new AttackAnimationData(43, 34, 35, 36, 37), KeeperEntity.AttackType.Slash_Stab, new AttackAnimationData(38, 13, 33), KeeperEntity.AttackType.Triple_Slash, new AttackAnimationData(41, 11, 21, 35));

    public KeeperAnimatedWarlockAttackGoal(KeeperEntity abstractSpellCastingMob, double pSpeedModifier, int minAttackInterval, int maxAttackInterval, float meleeRange) {
        super(abstractSpellCastingMob, pSpeedModifier, minAttackInterval, maxAttackInterval, meleeRange);
        this.keeper = abstractSpellCastingMob;
        this.currentAttack = this.keeper.getNextAttackType();
        this.meleeBias = 1.0f;
        this.wantsToMelee = true;
    }

    @Override
    protected void handleAttackLogic(double distanceSquared) {
        float distance = Mth.m_14116_((float)((float)distanceSquared));
        if (this.meleeAnimTimer > 0) {
            this.forceFaceTarget();
            --this.meleeAnimTimer;
            if (this.attackAnimations.get((Object)this.currentAttack).isHitFrame(this.meleeAnimTimer)) {
                if (this.currentAttack == KeeperEntity.AttackType.Lunge) {
                    if (!this.hasLunged) {
                        Vec3 lunge = this.target.m_20182_().m_82546_(this.mob.m_20182_()).m_82541_().m_82542_(2.4, 0.5, 2.4).m_82520_(0.0, 0.15, 0.0);
                        this.mob.m_5997_(lunge.f_82479_, lunge.f_82480_, lunge.f_82481_);
                        this.hasLunged = true;
                    }
                    if (!this.hasHitLunge && distance <= this.meleeRange * 0.6f) {
                        this.mob.m_7327_((Entity)this.target);
                        this.target.m_147240_(1.0, (double)Mth.m_14031_((float)(this.mob.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.mob.m_146908_() * ((float)Math.PI / 180)))));
                        this.hasHitLunge = true;
                    }
                } else {
                    Vec3 lunge = this.target.m_20182_().m_82546_(this.mob.m_20182_()).m_82541_().m_82490_((double)0.55f);
                    this.mob.m_5997_(lunge.f_82479_, lunge.f_82480_, lunge.f_82481_);
                    if (distance <= this.meleeRange) {
                        this.mob.m_7327_((Entity)this.target);
                        this.target.f_19802_ = 0;
                    }
                }
            }
        } else if (this.meleeAnimTimer == 0) {
            this.resetAttackTimer(distanceSquared);
            this.keeper.randomizeNextAttack();
            this.meleeAnimTimer = -1;
        } else {
            this.mob.m_21391_((Entity)this.target, 15.0f, 15.0f);
            int n = this.keeper.getNextAttackType() == KeeperEntity.AttackType.Lunge ? 3 : 1;
            if (distance < this.meleeRange * (float)n) {
                if (--this.attackTime == 0) {
                    this.mob.m_6674_(InteractionHand.MAIN_HAND);
                    this.doMeleeAction();
                } else if (this.attackTime < 0) {
                    this.resetAttackTimer(distanceSquared);
                }
            } else if (--this.attackTime < 0) {
                this.resetAttackTimer(distanceSquared);
                this.keeper.randomizeNextAttack();
            }
        }
    }

    private void forceFaceTarget() {
        if (this.hasLunged) {
            return;
        }
        double d0 = this.target.m_20185_() - this.mob.m_20185_();
        double d1 = this.target.m_20189_() - this.mob.m_20189_();
        float yRot = (float)(Mth.m_14136_((double)d1, (double)d0) * 57.2957763671875) - 90.0f;
        this.mob.m_5618_(yRot);
        this.mob.m_5616_(yRot);
        this.mob.m_146922_(yRot);
    }

    @Override
    protected void doMeleeAction() {
        this.currentAttack = this.keeper.getNextAttackType();
        this.meleeAnimTimer = this.attackAnimations.get((Object)((Object)this.currentAttack)).lengthInTicks;
        this.hasLunged = false;
        this.hasHitLunge = false;
    }

    @Override
    protected void doMovement(double distanceSquared) {
        if (distanceSquared > (double)(this.meleeRange * this.meleeRange)) {
            if (this.isFlying) {
                this.mob.m_21566_().m_6849_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_(), this.speedModifier * (double)1.3f);
            } else {
                this.mob.m_21573_().m_5624_((Entity)this.target, this.speedModifier * (double)1.3f);
            }
        }
    }
}

