/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.mobs.goals;

import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.SpellType;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class WizardAttackGoal
extends Goal {
    protected final AbstractSpellCastingMob mob;
    protected LivingEntity target;
    protected final double speedModifier;
    protected final int attackIntervalMin;
    protected final int attackIntervalMax;
    protected final float attackRadius;
    protected final float attackRadiusSqr;
    protected boolean shortCircuitTemp = false;
    protected boolean hasLineOfSight;
    protected int seeTime = 0;
    protected int strafeTime;
    protected boolean strafingClockwise;
    protected int attackTime = -1;
    protected int projectileCount;
    protected SpellType singleUseSpell = SpellType.NONE_SPELL;
    protected int singleUseDelay;
    protected int singleUseLevel;
    protected boolean isFlying;
    protected final ArrayList<SpellType> attackSpells = new ArrayList();
    protected final ArrayList<SpellType> defenseSpells = new ArrayList();
    protected final ArrayList<SpellType> movementSpells = new ArrayList();
    protected final ArrayList<SpellType> supportSpells = new ArrayList();
    protected ArrayList<SpellType> lastSpellCategory = this.attackSpells;
    protected int minSpellLevel = 1;
    protected int maxSpellLevel = 3;
    protected boolean drinksPotions;

    public WizardAttackGoal(AbstractSpellCastingMob abstractSpellCastingMob, double pSpeedModifier, int pAttackInterval) {
        this(abstractSpellCastingMob, pSpeedModifier, pAttackInterval, pAttackInterval);
    }

    public WizardAttackGoal(AbstractSpellCastingMob abstractSpellCastingMob, double pSpeedModifier, int pAttackIntervalMin, int pAttackIntervalMax) {
        this.mob = abstractSpellCastingMob;
        this.speedModifier = pSpeedModifier;
        this.attackIntervalMin = pAttackIntervalMin;
        this.attackIntervalMax = pAttackIntervalMax;
        this.attackRadius = 20.0f;
        this.attackRadiusSqr = this.attackRadius * this.attackRadius;
        this.attackSpells.add(SpellType.MAGIC_MISSILE_SPELL);
        this.attackSpells.add(SpellType.MAGIC_MISSILE_SPELL);
        this.attackSpells.add(SpellType.MAGIC_MISSILE_SPELL);
        this.attackSpells.add(SpellType.FANG_STRIKE_SPELL);
        this.attackSpells.add(SpellType.FANG_STRIKE_SPELL);
        this.attackSpells.add(SpellType.ELECTROCUTE_SPELL);
        this.defenseSpells.add(SpellType.SHIELD_SPELL);
        this.defenseSpells.add(SpellType.EVASION_SPELL);
        this.movementSpells.add(SpellType.TELEPORT_SPELL);
        this.supportSpells.add(SpellType.HEAL_SPELL);
    }

    public WizardAttackGoal setSpells(List<SpellType> attackSpells, List<SpellType> defenseSpells, List<SpellType> movementSpells, List<SpellType> supportSpells) {
        this.attackSpells.clear();
        this.defenseSpells.clear();
        this.movementSpells.clear();
        this.supportSpells.clear();
        this.attackSpells.addAll(attackSpells);
        this.defenseSpells.addAll(defenseSpells);
        this.movementSpells.addAll(movementSpells);
        this.supportSpells.addAll(supportSpells);
        return this;
    }

    public WizardAttackGoal setSpellLevels(int minLevel, int maxLevel) {
        this.minSpellLevel = minLevel;
        this.maxSpellLevel = maxLevel;
        return this;
    }

    public WizardAttackGoal setSingleUseSpell(SpellType spellType, int minDelay, int maxDelay, int minLevel, int maxLevel) {
        this.singleUseSpell = spellType;
        this.singleUseDelay = Mth.m_144928_((Random)this.mob.f_19853_.f_46441_, (int)minDelay, (int)maxDelay);
        this.singleUseLevel = Mth.m_144928_((Random)this.mob.f_19853_.f_46441_, (int)minLevel, (int)maxLevel);
        return this;
    }

    public WizardAttackGoal setIsFlying() {
        this.isFlying = true;
        return this;
    }

    public WizardAttackGoal setDrinksPotions() {
        this.drinksPotions = true;
        return this;
    }

    public boolean m_8036_() {
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity != null && livingentity.m_6084_()) {
            this.target = livingentity;
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        return this.m_8036_() || this.target.m_6084_() && !this.mob.m_21573_().m_26571_();
    }

    public void m_8041_() {
        this.target = null;
        this.seeTime = 0;
        this.attackTime = -1;
        this.mob.m_21561_(false);
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        if (this.target == null) {
            return;
        }
        double distanceSquared = this.mob.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        this.hasLineOfSight = this.mob.m_21574_().m_148306_((Entity)this.target);
        this.seeTime = this.hasLineOfSight ? ++this.seeTime : 0;
        this.doMovement(distanceSquared);
        if (this.mob.m_21213_() == this.mob.f_19797_ - 1) {
            int t;
            this.attackTime = t = (int)(Mth.m_14179_((float)0.6f, (float)this.attackTime, (float)0.0f) + 1.0f);
        }
        if (!this.mob.isDrinkingPotion()) {
            this.handleAttackLogic(distanceSquared);
        }
    }

    protected void handleAttackLogic(double distanceSquared) {
        if (--this.attackTime == 0) {
            if (!this.mob.isCasting()) {
                this.doSpellAction();
            }
            this.resetAttackTimer(distanceSquared);
        } else if (this.attackTime < 0) {
            this.attackTime = Mth.m_14107_((double)Mth.m_14139_((double)(Math.sqrt(distanceSquared) / (double)this.attackRadius), (double)this.attackIntervalMin, (double)this.attackIntervalMax));
        }
        if (this.mob.isCasting()) {
            PlayerMagicData pmg = PlayerMagicData.getPlayerMagicData((LivingEntity)this.mob);
            if (this.target.m_21224_() || AbstractSpell.getSpell(pmg.getCastingSpellId(), pmg.getCastingSpellLevel()).shouldAIStopCasting(this.mob, this.target)) {
                this.mob.cancelCast();
            }
        }
    }

    protected void resetAttackTimer(double distanceSquared) {
        float f = (float)Math.sqrt(distanceSquared) / this.attackRadius;
        this.attackTime = Mth.m_14143_((float)(f * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin));
    }

    protected void doMovement(double distanceSquared) {
        float movementDebuff = this.mob.isCasting() ? 0.2f : 1.0f;
        double effectiveSpeed = this.speedModifier;
        if (distanceSquared < (double)this.attackRadiusSqr && this.seeTime >= 5) {
            int strafeDir;
            this.mob.m_21573_().m_26573_();
            if (++this.strafeTime > 25 && this.mob.m_21187_().nextDouble() < 0.1) {
                this.strafingClockwise = !this.strafingClockwise;
                this.strafeTime = 0;
            }
            int n = strafeDir = this.strafingClockwise ? 1 : -1;
            if (distanceSquared < (double)(this.attackRadiusSqr * 0.5f)) {
                this.mob.m_21566_().m_24988_(-((float)effectiveSpeed), (float)effectiveSpeed * (float)strafeDir);
            } else {
                this.mob.m_21566_().m_24988_(0.0f, (float)effectiveSpeed * (float)strafeDir);
            }
            this.mob.m_21391_((Entity)this.target, 30.0f, 30.0f);
        } else if (this.isFlying) {
            this.mob.m_21566_().m_6849_(this.target.m_20185_(), this.target.m_20186_() + 2.0, this.target.m_20189_(), this.speedModifier);
        } else {
            this.mob.m_21573_().m_5624_((Entity)this.target, effectiveSpeed);
        }
    }

    protected void doSpellAction() {
        if (!this.mob.hasUsedSingleAttack && this.singleUseSpell != SpellType.NONE_SPELL && --this.singleUseDelay <= 0) {
            this.mob.hasUsedSingleAttack = true;
            this.mob.initiateCastSpell(this.singleUseSpell, this.singleUseLevel);
        } else {
            int spellLevel = Mth.m_144928_((Random)this.mob.m_21187_(), (int)this.minSpellLevel, (int)this.maxSpellLevel);
            SpellType spellType = this.getNextSpellType();
            if (!AbstractSpell.getSpell(spellType, spellLevel).shouldAIStopCasting(this.mob, this.target)) {
                this.mob.initiateCastSpell(spellType, spellLevel);
            }
        }
    }

    protected SpellType getNextSpellType() {
        TreeMap<Integer, ArrayList<SpellType>> weightedSpells = new TreeMap<Integer, ArrayList<SpellType>>();
        int attackWeight = this.getAttackWeight();
        int defenseWeight = this.getDefenseWeight() - (this.lastSpellCategory == this.defenseSpells ? 100 : 0);
        int movementWeight = this.getMovementWeight() - (this.lastSpellCategory == this.movementSpells ? 50 : 0);
        int supportWeight = this.getSupportWeight() - (this.lastSpellCategory == this.supportSpells ? 35 : 0);
        int total = 0;
        if (!this.attackSpells.isEmpty() && attackWeight > 0) {
            weightedSpells.put(total += attackWeight, this.attackSpells);
        }
        if (!this.defenseSpells.isEmpty() && defenseWeight > 0) {
            weightedSpells.put(total += defenseWeight, this.defenseSpells);
        }
        if (!this.movementSpells.isEmpty() && movementWeight > 0) {
            weightedSpells.put(total += movementWeight, this.movementSpells);
        }
        if ((!this.supportSpells.isEmpty() || this.drinksPotions) && supportWeight > 0) {
            weightedSpells.put(total += supportWeight, this.supportSpells);
        }
        if (total > 0) {
            ArrayList spellList;
            int seed = this.mob.m_21187_().nextInt(total);
            this.lastSpellCategory = spellList = (ArrayList)weightedSpells.higherEntry(seed).getValue();
            if (this.drinksPotions && spellList == this.supportSpells && (this.supportSpells.isEmpty() || this.mob.m_21187_().nextFloat() < 0.5f)) {
                IronsSpellbooks.LOGGER.debug("Drinking Potion");
                this.mob.startDrinkingPotion();
                return SpellType.NONE_SPELL;
            }
            return (SpellType)((Object)spellList.get(this.mob.m_21187_().nextInt(spellList.size())));
        }
        return SpellType.NONE_SPELL;
    }

    public void m_8056_() {
        super.m_8056_();
        this.mob.m_21561_(true);
    }

    protected int getAttackWeight() {
        int baseWeight = 80;
        if (this.target == null) {
            return baseWeight;
        }
        float targetHealth = this.target.m_21223_() / this.target.m_21233_();
        int targetHealthWeight = (int)((1.0f - targetHealth) * (float)baseWeight * 0.75f);
        double distanceSquared = this.mob.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        int distanceWeight = (int)(1.0 - distanceSquared / (double)this.attackRadiusSqr * -60.0);
        if (this.hasLineOfSight) {
            return baseWeight + targetHealthWeight + distanceWeight;
        }
        return 0;
    }

    protected int getDefenseWeight() {
        int baseWeight = -20;
        if (this.target == null) {
            return baseWeight;
        }
        float x = this.mob.m_21223_();
        float m = this.mob.m_21233_();
        int healthWeight = (int)(50.0f * (-(x * x * x) / (m * m * m) + 1.0f));
        float targetHealth = this.target.m_21223_() / this.target.m_21233_();
        int targetHealthWeight = (int)(1.0f - targetHealth) * -35;
        int threatWeight = this.projectileCount * 95;
        return baseWeight + healthWeight + targetHealthWeight + threatWeight;
    }

    protected int getMovementWeight() {
        if (this.target == null) {
            return 0;
        }
        double distanceSquared = this.mob.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        double distancePercent = Mth.m_14008_((double)(distanceSquared / (double)this.attackRadiusSqr), (double)0.0, (double)1.0);
        int distanceWeight = (int)(distancePercent * 50.0);
        int losWeight = this.hasLineOfSight ? 0 : 80;
        float healthInverted = 1.0f - this.mob.m_21223_() / this.mob.m_21233_();
        float distanceInverted = (float)(1.0 - distancePercent);
        int runWeight = (int)(400.0f * healthInverted * healthInverted * distanceInverted * distanceInverted);
        return distanceWeight + losWeight + runWeight;
    }

    protected int getSupportWeight() {
        int baseWeight = -15;
        if (this.target == null) {
            return baseWeight;
        }
        float health = 1.0f - this.mob.m_21223_() / this.mob.m_21233_();
        int healthWeight = (int)(200.0f * health);
        return baseWeight + healthWeight;
    }
}

