/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.mobs.goals;

import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.spells.SpellType;
import java.util.Random;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class SpellBarrageGoal
extends Goal {
    protected static final int interval = 5;
    protected final AbstractSpellCastingMob mob;
    protected LivingEntity target;
    protected final int attackIntervalMin;
    protected final int attackIntervalMax;
    protected final float attackRadius;
    protected final float attackRadiusSqr;
    protected final int projectileCount;
    protected final SpellType spell;
    protected int attackTime;
    protected final int minSpellLevel;
    protected final int maxSpellLevel;

    public SpellBarrageGoal(AbstractSpellCastingMob abstractSpellCastingMob, SpellType spell, int minLevel, int maxLevel, int pAttackIntervalMin, int pAttackIntervalMax, int projectileCount) {
        this.mob = abstractSpellCastingMob;
        this.attackIntervalMin = pAttackIntervalMin;
        this.attackIntervalMax = pAttackIntervalMax;
        this.attackRadius = 20.0f;
        this.attackRadiusSqr = this.attackRadius * this.attackRadius;
        this.minSpellLevel = minLevel;
        this.maxSpellLevel = maxLevel;
        this.projectileCount = projectileCount;
        this.spell = spell;
        this.resetAttackTimer();
    }

    public boolean m_8036_() {
        this.target = this.mob.m_5448_();
        if (this.target == null || this.mob.isCasting()) {
            return false;
        }
        if (this.attackTime <= -5 * (this.projectileCount - 1)) {
            this.resetAttackTimer();
        }
        return --this.attackTime <= 0 && this.attackTime % 5 == 0;
    }

    public boolean m_8045_() {
        return false;
    }

    public void m_8041_() {
        this.target = null;
        if (this.attackTime > 0) {
            this.attackTime = -this.projectileCount * 5 - 1;
        }
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        if (this.target == null) {
            return;
        }
        double distanceSquared = this.mob.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        if (distanceSquared < (double)this.attackRadiusSqr) {
            this.mob.m_21563_().m_24960_((Entity)this.target, 45.0f, 45.0f);
            this.mob.initiateCastSpell(this.spell, Mth.m_144928_((Random)this.mob.m_21187_(), (int)this.minSpellLevel, (int)this.maxSpellLevel));
        }
    }

    protected void resetAttackTimer() {
        this.attackTime = Mth.m_144928_((Random)this.mob.m_21187_(), (int)this.attackIntervalMin, (int)this.attackIntervalMax);
    }
}

