/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.mobs.goals;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class PatrolNearLocationGoal
extends Goal {
    private final PathfinderMob mob;
    private final int maxRadius;
    private final float speedModifier;
    private Vec3 patrolLocationCenter = null;
    private final Random random = new Random();
    private BlockPos targeBlock;
    private long cooldownUntil;

    public PatrolNearLocationGoal(PathfinderMob mob, int maxRadius, float speedModifier) {
        this.mob = mob;
        this.maxRadius = maxRadius;
        this.speedModifier = speedModifier;
        this.patrolLocationCenter = null;
        this.cooldownUntil = 0L;
    }

    public boolean m_8036_() {
        boolean isOnCooldown = this.mob.f_19853_.m_46467_() < this.cooldownUntil;
        return this.mob.m_5448_() == null && !isOnCooldown;
    }

    public void m_8041_() {
    }

    public void m_8037_() {
        PathNavigation pathnavigation = this.mob.m_21573_();
        if (this.patrolLocationCenter == null || pathnavigation.m_26571_()) {
            this.getNextTargetBlock();
            if (!pathnavigation.m_26519_((double)this.targeBlock.m_123341_(), (double)this.targeBlock.m_123342_(), (double)this.targeBlock.m_123343_(), (double)this.speedModifier)) {
                this.getNextTargetBlock();
                this.cooldownUntil = this.mob.f_19853_.m_46467_() + 200L;
            }
        }
    }

    private void getNextTargetBlock() {
        if (this.patrolLocationCenter == null) {
            this.patrolLocationCenter = this.mob.m_146892_();
        }
        Vec3 pos = this.patrolLocationCenter.m_82549_(this.getRandomPosInRadius());
        this.targeBlock = this.mob.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos(pos));
    }

    private Vec3 getRandomPosInRadius() {
        return new Vec3((double)(this.random.nextInt(this.maxRadius * 2) - this.maxRadius), 10.0, (double)(this.random.nextInt(this.maxRadius * 2) - this.maxRadius));
    }

    protected boolean isValidTarget(LevelReader pLevel, BlockPos pPos) {
        return true;
    }
}

