/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.mobs.dead_king_boss;

import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.entity.mobs.dead_king_boss.DeadKingBoss;
import io.redspace.ironsspellbooks.registries.AttributeRegistry;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.util.Utils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class DeadKingCorpseEntity
extends AbstractSpellCastingMob {
    private static final EntityDataAccessor<Boolean> TRIGGERED = SynchedEntityData.m_135353_(DeadKingCorpseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int currentAnimTime;
    private final int animLength = 300;
    private final AnimationBuilder idle = new AnimationBuilder().addAnimation("dead_king_rest", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    private final AnimationBuilder rise = new AnimationBuilder().addAnimation("dead_king_rise", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);

    public DeadKingCorpseEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_5829_() {
        return true;
    }

    protected boolean m_8028_() {
        return false;
    }

    public boolean m_21532_() {
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.triggered()) {
            ++this.currentAnimTime;
            if (!this.f_19853_.f_46443_) {
                if (this.currentAnimTime > 300) {
                    DeadKingBoss boss = new DeadKingBoss(this.f_19853_);
                    boss.m_20219_(this.m_20182_().m_82520_(0.0, 1.0, 0.0));
                    boss.m_6518_((ServerLevelAccessor)((ServerLevel)this.f_19853_), this.f_19853_.m_6436_(boss.m_20097_()), MobSpawnType.TRIGGERED, null, null);
                    int playerCount = Math.max(this.f_19853_.m_45976_(Player.class, boss.m_142469_().m_82400_(32.0)).size(), 1);
                    boss.m_21204_().m_22146_(Attributes.f_22276_).m_22125_(new AttributeModifier("Gank Health Bonus", (double)(playerCount - 1) * 0.5, AttributeModifier.Operation.MULTIPLY_BASE));
                    boss.m_21153_(boss.m_21233_());
                    boss.m_21204_().m_22146_(Attributes.f_22281_).m_22125_(new AttributeModifier("Gank Damage Bonus", (double)(playerCount - 1) * 0.25, AttributeModifier.Operation.MULTIPLY_BASE));
                    boss.m_21204_().m_22146_((Attribute)AttributeRegistry.SPELL_RESIST.get()).m_22125_(new AttributeModifier("Gank Spell Resist Bonus", (double)(playerCount - 1) * 0.1, AttributeModifier.Operation.MULTIPLY_BASE));
                    boss.m_21530_();
                    this.f_19853_.m_7967_((Entity)boss);
                    MagicManager.spawnParticles(this.f_19853_, (ParticleOptions)ParticleTypes.f_123746_, this.m_20182_().f_82479_, this.m_20182_().f_82480_ + 2.5, this.m_20182_().f_82481_, 80, 0.2, 0.2, 0.2, 0.25, true);
                    this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundRegistry.DEAD_KING_SPAWN.get(), SoundSource.MASTER, 20.0f, 1.0f);
                    this.m_146870_();
                }
            } else {
                this.resurrectParticles();
            }
        }
    }

    private void resurrectParticles() {
        float f = (float)this.currentAnimTime / 300.0f;
        float rot = (float)(this.currentAnimTime * 12) + (1.0f + f * 15.0f);
        float height = f * 4.0f + 0.4f * Mth.m_14031_((float)((float)(this.currentAnimTime * 30) * ((float)Math.PI / 180))) * f * f;
        float distance = Mth.m_14036_((float)Utils.smoothstep(0.0f, 1.15f, f * 3.0f), (float)0.0f, (float)1.15f);
        Vec3 pos = new Vec3(0.0, 0.0, (double)distance).m_82524_(rot * ((float)Math.PI / 180)).m_82520_(0.0, (double)height, 0.0).m_82549_(this.m_20182_());
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123746_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
        float radius = 4.0f;
        if (this.f_19796_.nextFloat() < f * 1.5f) {
            Vec3 random = this.m_20182_().m_82549_(new Vec3((double)((this.f_19796_.nextFloat() * 2.0f - 1.0f) * radius), 3.5 + (double)((this.f_19796_.nextFloat() * 2.0f - 1.0f) * radius), (double)((this.f_19796_.nextFloat() * 2.0f - 1.0f) * radius)));
            Vec3 motion = this.m_20182_().m_82546_(random).m_82490_((double)0.04f);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123746_, random.f_82479_, random.f_82480_, random.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource.m_19378_()) {
            this.m_146870_();
            return true;
        }
        Player player = this.f_19853_.m_45930_((Entity)this, 8.0);
        if (player != null) {
            this.trigger();
        }
        return false;
    }

    protected InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        if (!this.triggered()) {
            this.trigger();
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(pPlayer, pHand);
    }

    private void trigger() {
        if (!this.triggered()) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundRegistry.DEAD_KING_RESURRECT.get(), SoundSource.AMBIENT, 2.0f, 1.0f);
            this.f_19804_.m_135381_(TRIGGERED, (Object)true);
        }
    }

    private boolean triggered() {
        return (Boolean)this.f_19804_.m_135370_(TRIGGERED);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TRIGGERED, (Object)false);
    }

    @Override
    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "idle", 0.0f, this::idlePredicate));
    }

    private PlayState idlePredicate(AnimationEvent event) {
        if (this.triggered()) {
            event.getController().setAnimation(this.rise);
        } else {
            event.getController().setAnimation(this.idle);
        }
        return PlayState.CONTINUE;
    }

    @Override
    public boolean shouldBeExtraAnimated() {
        return false;
    }

    @Override
    public boolean shouldAlwaysAnimateHead() {
        return false;
    }
}

