/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.mobs.dead_king_boss;

import io.redspace.ironsspellbooks.entity.mobs.dead_king_boss.DeadKingBoss;
import io.redspace.ironsspellbooks.entity.mobs.goals.WarlockAttackGoal;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.util.Utils;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DeadKingAnimatedWarlockAttackGoal
extends WarlockAttackGoal {
    final DeadKingBoss boss;
    int meleeAnimTimer = -1;
    int animationDuration = 40;
    int firstSwingTimestamp = this.animationDuration - 14;
    int secondSwingTimestamp = this.animationDuration - 20;
    int swingSoundTimestamp = this.animationDuration - 13;
    int slamTimestamp = this.animationDuration - 25;
    int slamSoundTimestamp = this.animationDuration - 22;
    boolean slam;

    public DeadKingAnimatedWarlockAttackGoal(DeadKingBoss abstractSpellCastingMob, double pSpeedModifier, int minAttackInterval, int maxAttackInterval, float meleeRange) {
        super(abstractSpellCastingMob, pSpeedModifier, minAttackInterval, maxAttackInterval, meleeRange);
        this.boss = abstractSpellCastingMob;
    }

    @Override
    protected void handleAttackLogic(double distanceSquared) {
        if (this.meleeAnimTimer > 0) {
            this.mob.m_21391_((Entity)this.target, 50.0f, 50.0f);
            --this.meleeAnimTimer;
            if (this.slam) {
                if (this.meleeAnimTimer == this.slamSoundTimestamp) {
                    this.mob.m_5496_((SoundEvent)SoundRegistry.DEAD_KING_SLAM.get(), 1.0f, 1.0f);
                }
                if (this.meleeAnimTimer == this.slamTimestamp) {
                    Vec3 slamPos = this.mob.m_20182_().m_82549_(this.mob.m_20156_().m_82542_(1.0, 0.0, 1.0).m_82541_());
                    Vec3 bbHalf = new Vec3((double)this.meleeRange, (double)this.meleeRange, (double)this.meleeRange).m_82490_(0.4);
                    this.mob.f_19853_.m_45976_(this.target.getClass(), new AABB(slamPos.m_82546_(bbHalf), slamPos.m_82549_(bbHalf))).forEach(entity -> {
                        Player player;
                        float damage = (float)this.mob.m_21133_(Attributes.f_22281_) * 1.5f;
                        entity.m_6469_(DamageSource.m_19370_((LivingEntity)this.mob), damage);
                        Utils.throwTarget((LivingEntity)this.mob, entity, 7.0f, true);
                        if (entity instanceof Player && (player = (Player)entity).m_21254_()) {
                            player.m_36384_(true);
                        }
                    });
                }
            } else {
                if (this.meleeAnimTimer == this.swingSoundTimestamp) {
                    this.mob.m_5496_((SoundEvent)SoundRegistry.DEAD_KING_SWING.get(), 1.0f, 1.0f);
                }
                if ((this.meleeAnimTimer == this.firstSwingTimestamp || this.meleeAnimTimer == this.secondSwingTimestamp) && distanceSquared <= (double)(this.meleeRange * this.meleeRange)) {
                    this.mob.m_7327_((Entity)this.target);
                    this.target.f_19802_ = 0;
                }
            }
            ++this.meleeTimeDelay;
        } else if (this.meleeAnimTimer == 0) {
            this.resetAttackTimer(distanceSquared);
            this.boss.setNextSlam(this.mob.m_21187_().nextFloat() < 0.33f);
            this.meleeAnimTimer = -1;
        }
        super.handleAttackLogic(distanceSquared);
    }

    @Override
    protected void doMeleeAction() {
        this.meleeAnimTimer = this.animationDuration;
        this.slam = this.boss.isNextSlam();
    }
}

