/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob;

import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.capabilities.magic.SyncedSpellData;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.CastSource;
import io.redspace.ironsspellbooks.spells.CastType;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.spells.ender.TeleportSpell;
import io.redspace.ironsspellbooks.spells.fire.BurningDashSpell;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.EnumMap;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public abstract class AbstractSpellCastingMob
extends Monster
implements IAnimatable {
    public static final ResourceLocation modelResource = new ResourceLocation("irons_spellbooks", "geo/abstract_casting_mob.geo.json");
    public static final ResourceLocation textureResource = new ResourceLocation("irons_spellbooks", "textures/entity/abstract_casting_mob/abstract_casting_mob.png");
    public static final ResourceLocation animationInstantCast = new ResourceLocation("irons_spellbooks", "animations/casting_animations.json");
    private static final EntityDataAccessor<Boolean> DATA_CANCEL_CAST = SynchedEntityData.m_135353_(AbstractSpellCastingMob.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_DRINKING_POTION = SynchedEntityData.m_135353_(AbstractSpellCastingMob.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final PlayerMagicData playerMagicData = new PlayerMagicData(true);
    private static final AttributeModifier SPEED_MODIFIER_DRINKING = new AttributeModifier(UUID.fromString("5CD17E52-A79A-43D3-A529-90FDE04B181E"), "Drinking speed penalty", -0.5, AttributeModifier.Operation.MULTIPLY_TOTAL);
    @Nullable
    private AbstractSpell castingSpell;
    private final EnumMap<SpellType, AbstractSpell> spells = new EnumMap(SpellType.class);
    private int drinkTime;
    public boolean hasUsedSingleAttack;
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private SpellType lastCastSpellType = SpellType.NONE_SPELL;
    private SpellType instantCastSpellType = SpellType.NONE_SPELL;
    private boolean cancelCastAnimation = false;
    private final AnimationBuilder idle = new AnimationBuilder().addAnimation("blank", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    private final AnimationController animationControllerOtherCast = new AnimationController((IAnimatable)this, "other_casting", 0.0f, this::otherCastingPredicate);
    private final AnimationController animationControllerInstantCast = new AnimationController((IAnimatable)this, "instant_casting", 0.0f, this::instantCastingPredicate);
    private final AnimationController animationControllerLongCast = new AnimationController((IAnimatable)this, "long_casting", 0.0f, this::longCastingPredicate);

    protected AbstractSpellCastingMob(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.playerMagicData.setSyncedData(new SyncedSpellData((LivingEntity)this));
    }

    public PlayerMagicData getPlayerMagicData() {
        return this.playerMagicData;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CANCEL_CAST, (Object)false);
        this.f_19804_.m_135372_(DATA_DRINKING_POTION, (Object)false);
    }

    public boolean isDrinkingPotion() {
        return (Boolean)this.f_19804_.m_135370_(DATA_DRINKING_POTION);
    }

    protected void setDrinkingPotion(boolean drinkingPotion) {
        this.f_19804_.m_135381_(DATA_DRINKING_POTION, (Object)drinkingPotion);
    }

    public void startDrinkingPotion() {
        if (!this.f_19853_.f_46443_) {
            this.setDrinkingPotion(true);
            this.drinkTime = 35;
            AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
            attributeinstance.m_22130_(SPEED_MODIFIER_DRINKING);
            attributeinstance.m_22118_(SPEED_MODIFIER_DRINKING);
        }
    }

    private void finishDrinkingPotion() {
        this.setDrinkingPotion(false);
        this.m_5634_(Math.min(10.0f, this.m_21233_() / 4.0f));
        this.m_21051_(Attributes.f_22279_).m_22130_(SPEED_MODIFIER_DRINKING);
        if (!this.m_20067_()) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12551_, this.m_5720_(), 1.0f, 0.8f + this.f_19796_.nextFloat() * 0.4f);
        }
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        super.m_7350_(pKey);
        if (!this.f_19853_.f_46443_) {
            return;
        }
        if (pKey.m_135015_() == DATA_CANCEL_CAST.m_135015_()) {
            IronsSpellbooks.LOGGER.debug("ASCM.onSyncedDataUpdated.1 this.isCasting:{}, playerMagicData.isCasting:{} isClient:{}", new Object[]{this.isCasting(), this.playerMagicData == null ? "null" : Boolean.valueOf(this.playerMagicData.isCasting()), this.f_19853_.m_5776_()});
            this.cancelCast();
        }
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.playerMagicData.getSyncedData().saveNBTData(pCompound);
        pCompound.m_128379_("usedSpecial", this.hasUsedSingleAttack);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        SyncedSpellData syncedSpellData = new SyncedSpellData((LivingEntity)this);
        syncedSpellData.loadNBTData(pCompound);
        this.playerMagicData.setSyncedData(syncedSpellData);
        this.hasUsedSingleAttack = pCompound.m_128471_("usedSpecial");
    }

    public void cancelCast() {
        if (this.isCasting()) {
            if (this.f_19853_.f_46443_) {
                this.cancelCastAnimation = true;
            } else {
                this.f_19804_.m_135381_(DATA_CANCEL_CAST, (Object)((Boolean)this.f_19804_.m_135370_(DATA_CANCEL_CAST) == false ? 1 : 0));
            }
            this.castComplete();
        }
    }

    private void castComplete() {
        if (!this.f_19853_.f_46443_) {
            if (this.castingSpell != null) {
                this.castingSpell.onServerCastComplete(this.f_19853_, (LivingEntity)this, this.playerMagicData, false);
            }
        } else {
            this.playerMagicData.resetCastingState();
        }
        this.castingSpell = null;
    }

    public void startAutoSpinAttack(int pAttackTicks) {
        this.f_20938_ = pAttackTicks;
        if (!this.f_19853_.f_46443_) {
            this.m_21155_(4, true);
        }
        this.m_146922_((float)(Math.atan2(this.m_20184_().f_82479_, this.m_20184_().f_82481_) * 57.2957763671875));
    }

    public void setSyncedSpellData(SyncedSpellData syncedSpellData) {
        if (!this.f_19853_.f_46443_) {
            return;
        }
        boolean isCasting = this.playerMagicData.isCasting();
        this.playerMagicData.setSyncedData(syncedSpellData);
        this.castingSpell = this.playerMagicData.getCastingSpell();
        IronsSpellbooks.LOGGER.debug("ASCM.setSyncedSpellData playerMagicData:{}, priorIsCastingState:{}, spell:{}", new Object[]{this.playerMagicData, isCasting, this.castingSpell});
        if (this.castingSpell == null) {
            return;
        }
        if (!this.playerMagicData.isCasting() && isCasting) {
            this.castComplete();
        } else if (this.playerMagicData.isCasting() && !isCasting) {
            SpellType spellType = SpellType.getTypeFromValue(this.playerMagicData.getCastingSpellId());
            this.initiateCastSpell(spellType, this.playerMagicData.getCastingSpellLevel());
            if (this.castingSpell.getCastType() == CastType.INSTANT) {
                this.instantCastSpellType = this.castingSpell.getSpellType();
                this.castingSpell.onClientPreCast(this.f_19853_, (LivingEntity)this, InteractionHand.MAIN_HAND, this.playerMagicData);
                this.castComplete();
            }
        }
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.isDrinkingPotion()) {
            if (this.drinkTime-- <= 0) {
                this.finishDrinkingPotion();
            } else if (this.drinkTime % 4 == 0 && !this.m_20067_()) {
                this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11911_, this.m_5720_(), 1.0f, this.f_19853_.f_46441_.nextFloat() * 0.1f + 0.9f);
            }
        }
        if (this.castingSpell == null) {
            return;
        }
        this.playerMagicData.handleCastDuration();
        if (this.playerMagicData.isCasting()) {
            this.castingSpell.onServerCastTick(this.f_19853_, (LivingEntity)this, this.playerMagicData);
        }
        IronsSpellbooks.LOGGER.debug("ASCM.customServerAiStep.1");
        this.forceLookAtTarget(this.m_5448_());
        if (this.playerMagicData.getCastDurationRemaining() <= 0) {
            IronsSpellbooks.LOGGER.debug("ASCM.customServerAiStep.2");
            if (this.castingSpell.getCastType() == CastType.LONG || this.castingSpell.getCastType() == CastType.CHARGE || this.castingSpell.getCastType() == CastType.INSTANT) {
                IronsSpellbooks.LOGGER.debug("ASCM.customServerAiStep.3");
                this.castingSpell.onCast(this.f_19853_, (LivingEntity)this, this.playerMagicData);
            }
            this.castComplete();
        } else if (this.castingSpell.getCastType() == CastType.CONTINUOUS && (this.playerMagicData.getCastDurationRemaining() + 1) % 10 == 0) {
            this.castingSpell.onCast(this.f_19853_, (LivingEntity)this, this.playerMagicData);
        }
    }

    public void initiateCastSpell(SpellType spellType, int spellLevel) {
        IronsSpellbooks.LOGGER.debug("ASCM.initiateCastSpell: spellType:{} spellLevel:{}, isClient:{}", new Object[]{spellType, spellLevel, this.f_19853_.f_46443_});
        if (spellType == SpellType.NONE_SPELL) {
            this.castingSpell = null;
            return;
        }
        if (this.f_19853_.f_46443_) {
            this.cancelCastAnimation = false;
        }
        this.castingSpell = this.spells.computeIfAbsent(spellType, key -> AbstractSpell.getSpell(spellType, spellLevel));
        if (this.m_5448_() != null) {
            this.forceLookAtTarget(this.m_5448_());
        }
        if (!this.f_19853_.f_46443_ && !this.castingSpell.checkPreCastConditions(this.f_19853_, (LivingEntity)this, this.playerMagicData)) {
            IronsSpellbooks.LOGGER.debug("ASCM.precastfailed: spellType:{} spellLevel:{}, isClient:{}", new Object[]{spellType, spellLevel, this.f_19853_.f_46443_});
            this.castingSpell = null;
            return;
        }
        if (spellType == SpellType.TELEPORT_SPELL || spellType == SpellType.FROST_STEP_SPELL) {
            this.setTeleportLocationBehindTarget(10);
        } else if (spellType == SpellType.BLOOD_STEP_SPELL) {
            this.setTeleportLocationBehindTarget(3);
        } else if (spellType == SpellType.BURNING_DASH_SPELL) {
            this.setBurningDashDirectionData();
        }
        this.playerMagicData.initiateCast(this.castingSpell.getID(), this.castingSpell.getLevel((LivingEntity)this), this.castingSpell.getEffectiveCastTime((LivingEntity)this), CastSource.MOB);
        if (!this.f_19853_.f_46443_) {
            this.castingSpell.onServerPreCast(this.f_19853_, (LivingEntity)this, this.playerMagicData);
        }
    }

    public boolean isCasting() {
        return this.playerMagicData.isCasting();
    }

    public void setTeleportLocationBehindTarget(int distance) {
        LivingEntity target = this.m_5448_();
        if (target != null) {
            Vec3 rotation = target.m_20154_().m_82541_().m_82490_((double)(-distance));
            Vec3 pos = target.m_20182_();
            Vec3 teleportPos = rotation.m_82549_(pos);
            boolean valid = false;
            for (int i = 0; i < 24; ++i) {
                teleportPos = target.m_20182_().m_82546_(new Vec3(0.0, 0.0, (double)((float)distance / (float)(i / 7 + 1))).m_82524_(-(target.m_146908_() + (float)(i * 45)) * ((float)Math.PI / 180)));
                int y = Utils.findRelativeGroundLevel(target.f_19853_, teleportPos, 5);
                teleportPos = new Vec3(teleportPos.f_82479_, (double)y, teleportPos.f_82481_);
                AABB bb = this.m_142469_().m_82400_(0.5);
                AABB reposBB = bb.m_82383_(teleportPos.m_82546_(this.m_20182_()));
                if (this.f_19853_.m_186437_((Entity)this, reposBB)) continue;
                IronsSpellbooks.LOGGER.debug("\n\n\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n\nsetTeleportLocationBehindTarget: {} {} {} empty. teleporting\n\n\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n\n", new Object[]{reposBB.f_82288_, reposBB.f_82289_, reposBB.f_82290_});
                valid = true;
                break;
            }
            if (valid) {
                IronsSpellbooks.LOGGER.debug("ASCM.setTeleportLocationBehindTarget: valid, pos:{}, isClient:{}", (Object)teleportPos, (Object)this.f_19853_.m_5776_());
                this.playerMagicData.setAdditionalCastData(new TeleportSpell.TeleportData(teleportPos));
            } else {
                IronsSpellbooks.LOGGER.debug("ASCM.setTeleportLocationBehindTarget: invalid, pos:{}, isClient:{}", (Object)teleportPos, (Object)this.f_19853_.m_5776_());
                this.playerMagicData.setAdditionalCastData(new TeleportSpell.TeleportData(this.m_20182_()));
            }
        } else {
            IronsSpellbooks.LOGGER.debug("ASCM.setTeleportLocationBehindTarget: no target, isClient:{}", (Object)this.f_19853_.m_5776_());
            this.playerMagicData.setAdditionalCastData(new TeleportSpell.TeleportData(this.m_20182_()));
        }
    }

    public void setBurningDashDirectionData() {
        this.playerMagicData.setAdditionalCastData(new BurningDashSpell.BurningDashDirectionOverrideCastData());
    }

    private void forceLookAtTarget(LivingEntity target) {
        if (target != null) {
            double d0 = target.m_20185_() - this.m_20185_();
            double d2 = target.m_20189_() - this.m_20189_();
            double d1 = target.m_20188_() - this.m_20188_();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
            float f1 = (float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875));
            this.m_146926_(f1 % 360.0f);
            this.m_146922_(f % 360.0f);
        }
    }

    private void addClientSideParticles() {
        double d0 = 0.4;
        double d1 = 0.3;
        double d2 = 0.35;
        float f = this.f_20883_ * ((float)Math.PI / 180) + Mth.m_14089_((float)((float)this.f_19797_ * 0.6662f)) * 0.25f;
        float f1 = Mth.m_14089_((float)f);
        float f2 = Mth.m_14031_((float)f);
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() + (double)f1 * 0.6, this.m_20186_() + 1.8, this.m_20189_() + (double)f2 * 0.6, d0, d1, d2);
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() - (double)f1 * 0.6, this.m_20186_() + 1.8, this.m_20189_() - (double)f2 * 0.6, d0, d1, d2);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(this.animationControllerOtherCast);
        data.addAnimationController(this.animationControllerInstantCast);
        data.addAnimationController(this.animationControllerLongCast);
        data.addAnimationController(new AnimationController((IAnimatable)this, "idle", 0.0f, this::idlePredicate));
    }

    private PlayState idlePredicate(AnimationEvent event) {
        event.getController().setAnimation(this.idle);
        return PlayState.STOP;
    }

    private PlayState instantCastingPredicate(AnimationEvent event) {
        if (this.cancelCastAnimation) {
            return PlayState.STOP;
        }
        AnimationController controller = event.getController();
        if (this.instantCastSpellType != SpellType.NONE_SPELL && controller.getAnimationState() == AnimationState.Stopped) {
            this.setStartAnimationFromSpell(controller, AbstractSpell.getSpell(this.instantCastSpellType, 1));
            this.instantCastSpellType = SpellType.NONE_SPELL;
        }
        return PlayState.CONTINUE;
    }

    private PlayState longCastingPredicate(AnimationEvent event) {
        if (this.cancelCastAnimation) {
            return PlayState.STOP;
        }
        AnimationController controller = event.getController();
        if (this.isCasting() && this.castingSpell != null && this.castingSpell.getCastType() == CastType.LONG && controller.getAnimationState() == AnimationState.Stopped) {
            this.setStartAnimationFromSpell(controller, this.castingSpell);
        }
        if (!this.isCasting()) {
            this.setFinishAnimationFromSpell(controller, this.lastCastSpellType);
        }
        return PlayState.CONTINUE;
    }

    private PlayState otherCastingPredicate(AnimationEvent event) {
        if (this.cancelCastAnimation) {
            return PlayState.STOP;
        }
        AnimationController controller = event.getController();
        if (this.isCasting() && this.castingSpell != null && controller.getAnimationState() == AnimationState.Stopped) {
            if (this.castingSpell.getCastType() == CastType.CONTINUOUS || this.castingSpell.getCastType() == CastType.CHARGE) {
                this.setStartAnimationFromSpell(controller, this.castingSpell);
            }
            return PlayState.CONTINUE;
        }
        if (this.isCasting()) {
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private void setStartAnimationFromSpell(AnimationController controller, AbstractSpell spell) {
        spell.getCastStartAnimation().getForMob().ifPresent(animationBuilder -> {
            IronsSpellbooks.LOGGER.debug("ASCM.setStartAnimationFromSpell {}", animationBuilder);
            controller.markNeedsReload();
            controller.setAnimation(animationBuilder);
            this.lastCastSpellType = spell.getSpellType();
            this.cancelCastAnimation = false;
        });
    }

    private void setFinishAnimationFromSpell(AnimationController controller, SpellType spellType) {
        AbstractSpell spell = AbstractSpell.getSpell(spellType, 1);
        spell.getCastFinishAnimation().getForMob().ifPresent(animationBuilder -> {
            controller.markNeedsReload();
            controller.setAnimation(animationBuilder);
            this.lastCastSpellType = SpellType.NONE_SPELL;
            this.cancelCastAnimation = false;
        });
    }

    public boolean isAnimating() {
        return this.isCasting() || this.animationControllerOtherCast.getAnimationState() != AnimationState.Stopped || this.animationControllerInstantCast.getAnimationState() != AnimationState.Stopped;
    }

    public boolean shouldBeExtraAnimated() {
        return true;
    }

    public boolean shouldAlwaysAnimateHead() {
        return true;
    }

    public boolean shouldAlwaysAnimateLegs() {
        return true;
    }

    public boolean shouldPointArmsWhileCasting() {
        return true;
    }
}

