/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.mobs;

import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.effect.SummonTimer;
import io.redspace.ironsspellbooks.entity.mobs.MagicSummon;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericCopyOwnerTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericFollowOwnerGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericHurtByTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericOwnerHurtByTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericOwnerHurtTargetGoal;
import io.redspace.ironsspellbooks.registries.EntityRegistry;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.OwnerHelper;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.EnumSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SummonedVex
extends Vex
implements MagicSummon {
    protected LivingEntity cachedSummoner;
    protected UUID summonerUUID;

    public SummonedVex(EntityType<? extends Vex> pEntityType, Level pLevel) {
        super((EntityType)EntityRegistry.SUMMONED_VEX.get(), pLevel);
        this.f_21364_ = 0;
    }

    public SummonedVex(Level pLevel, LivingEntity owner) {
        this((EntityType<? extends Vex>)((EntityType)EntityRegistry.SUMMONED_VEX.get()), pLevel);
        this.setSummoner(owner);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new VexChargeAttackGoal());
        this.f_21345_.m_25352_(7, (Goal)new GenericFollowOwnerGoal((PathfinderMob)this, this::getSummoner, 0.65f, 15.0f, 5.0f, true, 25.0f));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21345_.m_25352_(16, (Goal)new VexRandomMoveGoal());
        this.f_21346_.m_25352_(1, (Goal)new GenericOwnerHurtByTargetGoal((Mob)this, this::getSummoner));
        this.f_21346_.m_25352_(2, (Goal)new GenericOwnerHurtTargetGoal((Mob)this, this::getSummoner));
        this.f_21346_.m_25352_(3, (Goal)new GenericCopyOwnerTargetGoal((PathfinderMob)this, this::getSummoner));
        this.f_21346_.m_25352_(4, (Goal)new GenericHurtByTargetGoal((PathfinderMob)this, entity -> entity == this.getSummoner()).setAlertOthers(new Class[0]));
    }

    public boolean m_7327_(Entity pEntity) {
        return Utils.doMeleeAttack((Mob)this, pEntity, SpellType.SUMMON_VEX_SPELL.getDamageSource((Entity)this, (Entity)this.getSummoner()), SchoolType.EVOCATION);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.shouldIgnoreDamage(pSource)) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    @Override
    public LivingEntity getSummoner() {
        return OwnerHelper.getAndCacheOwner(this.f_19853_, this.cachedSummoner, this.summonerUUID);
    }

    public void setSummoner(@Nullable LivingEntity owner) {
        if (owner != null) {
            this.summonerUUID = owner.m_142081_();
            this.cachedSummoner = owner;
        }
    }

    public void m_6667_(DamageSource pDamageSource) {
        this.onDeathHelper();
        super.m_6667_(pDamageSource);
    }

    public void onRemovedFromWorld() {
        this.onRemovedHelper((Entity)this, (SummonTimer)((Object)MobEffectRegistry.VEX_TIMER.get()));
        super.onRemovedFromWorld();
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.summonerUUID = OwnerHelper.deserializeOwner(compoundTag);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        OwnerHelper.serializeOwner(compoundTag, this.summonerUUID);
    }

    public boolean m_7307_(Entity pEntity) {
        return super.m_7307_(pEntity) || this.isAlliedHelper(pEntity);
    }

    @Override
    public void onUnSummon() {
        if (!this.f_19853_.f_46443_) {
            MagicManager.spawnParticles(this.f_19853_, (ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 25, 0.4, 0.8, 0.4, 0.03, false);
            this.m_146870_();
        }
    }

    protected boolean m_8028_() {
        return false;
    }

    class VexChargeAttackGoal
    extends Goal {
        public VexChargeAttackGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = SummonedVex.this.m_5448_();
            if (livingentity != null && livingentity.m_6084_() && !SummonedVex.this.m_21566_().m_24995_() && SummonedVex.this.f_19796_.nextInt(VexChargeAttackGoal.m_186073_((int)7)) == 0) {
                return SummonedVex.this.m_20280_((Entity)livingentity) > 4.0;
            }
            return false;
        }

        public boolean m_8045_() {
            return SummonedVex.this.m_21566_().m_24995_() && SummonedVex.this.m_34028_() && SummonedVex.this.m_5448_() != null && SummonedVex.this.m_5448_().m_6084_();
        }

        public void m_8056_() {
            LivingEntity livingentity = SummonedVex.this.m_5448_();
            if (livingentity != null) {
                Vec3 vec3 = livingentity.m_146892_();
                SummonedVex.this.f_21342_.m_6849_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1.0);
            }
            SummonedVex.this.m_34042_(true);
            SummonedVex.this.m_5496_(SoundEvents.f_12500_, 1.0f, 1.0f);
        }

        public void m_8041_() {
            SummonedVex.this.m_34042_(false);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = SummonedVex.this.m_5448_();
            if (livingentity != null) {
                if (SummonedVex.this.m_142469_().m_82381_(livingentity.m_142469_())) {
                    SummonedVex.this.m_7327_((Entity)livingentity);
                    SummonedVex.this.m_34042_(false);
                } else {
                    double d0 = SummonedVex.this.m_20280_((Entity)livingentity);
                    if (d0 < 9.0) {
                        Vec3 vec3 = livingentity.m_146892_();
                        SummonedVex.this.f_21342_.m_6849_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1.0);
                    }
                }
            }
        }
    }

    class VexRandomMoveGoal
    extends Goal {
        public VexRandomMoveGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !SummonedVex.this.m_21566_().m_24995_() && SummonedVex.this.f_19796_.nextInt(VexRandomMoveGoal.m_186073_((int)7)) == 0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8037_() {
            BlockPos blockpos = SummonedVex.this.m_34027_();
            if (blockpos == null) {
                blockpos = SummonedVex.this.m_142538_();
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.m_142082_(SummonedVex.this.f_19796_.nextInt(15) - 7, SummonedVex.this.f_19796_.nextInt(11) - 5, SummonedVex.this.f_19796_.nextInt(15) - 7);
                if (!SummonedVex.this.f_19853_.m_46859_(blockpos1)) continue;
                SummonedVex.this.f_21342_.m_6849_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, 0.25);
                if (SummonedVex.this.m_5448_() != null) break;
                SummonedVex.this.m_21563_().m_24950_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }
}

