/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.damage;

import io.redspace.ironsspellbooks.entity.mobs.MagicSummon;
import io.redspace.ironsspellbooks.registries.AttributeRegistry;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.util.Utils;
import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.scores.Team;

public class DamageSources {
    public static DamageSource CAULDRON = new DamageSource("blood_cauldron");
    public static DamageSource HEARTSTOP = new DamageSource("heartstop").m_19380_().m_19382_();
    public static DamageSource BLEED_DAMAGE = new DamageSource("bleed_effect");
    public static DamageSource FIRE_MAGIC = new DamageSource("fire_magic_damage");
    public static DamageSource ICE_MAGIC = new DamageSource("ice_magic_damage");
    public static DamageSource LIGHTNING_MAGIC = new DamageSource("lightning_magic_damage");
    public static DamageSource HOLY_MAGIC = new DamageSource("holy_magic_damage");
    public static DamageSource BLOOD_MAGIC = new DamageSource("blood_magic_damage");
    public static DamageSource ENDER_MAGIC = new DamageSource("ender_magic_damage");
    public static DamageSource EVOCATION_MAGIC = new DamageSource("evocation_magic_damage");

    public static boolean applyDamage(Entity target, float baseAmount, DamageSource damageSource, @Nullable SchoolType damageSchool) {
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            float adjustedDamage = baseAmount * DamageSources.getResist(livingTarget, damageSchool);
            boolean fromSummon = false;
            Entity entity = damageSource.m_7640_();
            if (entity instanceof MagicSummon) {
                MagicSummon summon = (MagicSummon)entity;
                fromSummon = true;
                if (summon.getSummoner() != null) {
                    adjustedDamage = (float)((double)adjustedDamage * summon.getSummoner().m_21133_((Attribute)AttributeRegistry.SUMMON_DAMAGE.get()));
                }
            }
            if ((entity = damageSource.m_7639_()) instanceof LivingEntity) {
                LivingEntity livingAttacker = (LivingEntity)entity;
                if (DamageSources.isFriendlyFireBetween((Entity)livingAttacker, (Entity)livingTarget)) {
                    return false;
                }
                livingAttacker.m_21335_(target);
            }
            boolean flag = livingTarget.m_6469_(damageSource, adjustedDamage);
            if (fromSummon) {
                livingTarget.m_6703_((LivingEntity)damageSource.m_7640_());
            }
            return flag;
        }
        return target.m_6469_(damageSource, baseAmount);
    }

    public static boolean isFriendlyFireBetween(Entity attacker, Entity target) {
        if (attacker == null || target == null) {
            return false;
        }
        Team team = attacker.m_5647_();
        if (team != null) {
            return team.m_83536_(target.m_5647_()) && !team.m_6260_();
        }
        return false;
    }

    public static DamageSource directDamageSource(DamageSource source, Entity attacker) {
        return new EntityDamageSource(source.m_19385_(), attacker);
    }

    public static DamageSource indirectDamageSource(DamageSource source, Entity projectile, @Nullable Entity attacker) {
        return new IndirectEntityDamageSource(source.f_19326_, projectile, attacker);
    }

    public static float getResist(LivingEntity entity, SchoolType damageSchool) {
        return 2.0f - (float)Utils.softCapFormula(entity.m_21133_((Attribute)AttributeRegistry.SPELL_RESIST.get()));
    }
}

