/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.config;

import io.redspace.ironsspellbooks.spells.DefaultConfig;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.spells.blood.AcupunctureSpell;
import io.redspace.ironsspellbooks.spells.blood.BloodNeedlesSpell;
import io.redspace.ironsspellbooks.spells.blood.BloodSlashSpell;
import io.redspace.ironsspellbooks.spells.blood.BloodStepSpell;
import io.redspace.ironsspellbooks.spells.blood.HeartstopSpell;
import io.redspace.ironsspellbooks.spells.blood.RaiseDeadSpell;
import io.redspace.ironsspellbooks.spells.blood.RayOfSiphoningSpell;
import io.redspace.ironsspellbooks.spells.blood.WitherSkullSpell;
import io.redspace.ironsspellbooks.spells.ender.CounterspellSpell;
import io.redspace.ironsspellbooks.spells.ender.DragonBreathSpell;
import io.redspace.ironsspellbooks.spells.ender.EvasionSpell;
import io.redspace.ironsspellbooks.spells.ender.MagicArrowSpell;
import io.redspace.ironsspellbooks.spells.ender.MagicMissileSpell;
import io.redspace.ironsspellbooks.spells.ender.StarfallSpell;
import io.redspace.ironsspellbooks.spells.ender.TeleportSpell;
import io.redspace.ironsspellbooks.spells.evocation.ChainCreeperSpell;
import io.redspace.ironsspellbooks.spells.evocation.FangStrikeSpell;
import io.redspace.ironsspellbooks.spells.evocation.FangWardSpell;
import io.redspace.ironsspellbooks.spells.evocation.FirecrackerSpell;
import io.redspace.ironsspellbooks.spells.evocation.InvisibilitySpell;
import io.redspace.ironsspellbooks.spells.evocation.LobCreeperSpell;
import io.redspace.ironsspellbooks.spells.evocation.ShieldSpell;
import io.redspace.ironsspellbooks.spells.evocation.SpectralHammerSpell;
import io.redspace.ironsspellbooks.spells.evocation.SummonHorseSpell;
import io.redspace.ironsspellbooks.spells.evocation.SummonVexSpell;
import io.redspace.ironsspellbooks.spells.fire.BlazeStormSpell;
import io.redspace.ironsspellbooks.spells.fire.BurningDashSpell;
import io.redspace.ironsspellbooks.spells.fire.FireBombSpell;
import io.redspace.ironsspellbooks.spells.fire.FireBreathSpell;
import io.redspace.ironsspellbooks.spells.fire.FireballSpell;
import io.redspace.ironsspellbooks.spells.fire.FireboltSpell;
import io.redspace.ironsspellbooks.spells.fire.WallOfFireSpell;
import io.redspace.ironsspellbooks.spells.holy.AngelWingsSpell;
import io.redspace.ironsspellbooks.spells.holy.BlessingOfLifeSpell;
import io.redspace.ironsspellbooks.spells.holy.CloudOfRegenerationSpell;
import io.redspace.ironsspellbooks.spells.holy.FortifySpell;
import io.redspace.ironsspellbooks.spells.holy.GreaterHealSpell;
import io.redspace.ironsspellbooks.spells.holy.HealSpell;
import io.redspace.ironsspellbooks.spells.holy.HealingCircleSpell;
import io.redspace.ironsspellbooks.spells.holy.WispSpell;
import io.redspace.ironsspellbooks.spells.ice.ConeOfColdSpell;
import io.redspace.ironsspellbooks.spells.ice.FrostStepSpell;
import io.redspace.ironsspellbooks.spells.ice.FrostbiteSpell;
import io.redspace.ironsspellbooks.spells.ice.IceBlockSpell;
import io.redspace.ironsspellbooks.spells.ice.IcicleSpell;
import io.redspace.ironsspellbooks.spells.ice.SummonPolarBearSpell;
import io.redspace.ironsspellbooks.spells.lightning.AscensionSpell;
import io.redspace.ironsspellbooks.spells.lightning.ChargeSpell;
import io.redspace.ironsspellbooks.spells.lightning.ElectrocuteSpell;
import io.redspace.ironsspellbooks.spells.lightning.LightningBoltSpell;
import io.redspace.ironsspellbooks.spells.lightning.LightningLanceSpell;
import io.redspace.ironsspellbooks.spells.poison.AcidOrbSpell;
import io.redspace.ironsspellbooks.spells.poison.BlightSpell;
import io.redspace.ironsspellbooks.spells.poison.PoisonArrowSpell;
import io.redspace.ironsspellbooks.spells.poison.PoisonBreathSpell;
import io.redspace.ironsspellbooks.spells.poison.PoisonSplashSpell;
import io.redspace.ironsspellbooks.spells.poison.RootSpell;
import io.redspace.ironsspellbooks.spells.poison.SpiderAspectSpell;
import io.redspace.ironsspellbooks.spells.void_school.AbyssalShroudSpell;
import io.redspace.ironsspellbooks.spells.void_school.BlackHoleSpell;
import io.redspace.ironsspellbooks.spells.void_school.VoidTentaclesSpell;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.common.ForgeConfigSpec;

public class ServerConfigs {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final SpellConfigParameters DEFAULT_CONFIG;
    public static final ForgeConfigSpec.ConfigValue<Boolean> SWORDS_CONSUME_MANA;
    public static final ForgeConfigSpec.ConfigValue<Boolean> CAN_ATTACK_OWN_SUMMONS;
    public static final ForgeConfigSpec.ConfigValue<Integer> MAX_UPGRADES;
    public static final ForgeConfigSpec.ConfigValue<Double> MANA_SPAWN_PERCENT;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> UPGRADE_WHITELIST;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> UPGRADE_BLACKLIST;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> IMBUE_WHITELIST;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> IMBUE_BLACKLIST;
    public static final ForgeConfigSpec.ConfigValue<List<? extends Double>> RARITY_CONFIG;
    private static final Map<SpellType, SpellConfigParameters> SPELL_CONFIGS;

    public static SpellConfigParameters getSpellConfig(SpellType spellType) {
        return SPELL_CONFIGS.getOrDefault((Object)spellType, DEFAULT_CONFIG);
    }

    public static SpellConfigParameters getSpellConfig(int spellId) {
        return ServerConfigs.getSpellConfig(SpellType.getTypeFromValue(spellId));
    }

    public static Map<SpellType, SpellConfigParameters> getSpellConfigs() {
        return SPELL_CONFIGS;
    }

    private static void createSpellConfig(SpellType spell, DefaultConfig config, boolean enabledByDefault) {
        BUILDER.push(ServerConfigs.createSpellConfigTitle(spell.getId()));
        SPELL_CONFIGS.put(spell, new SpellConfigParameters((Supplier<Boolean>)BUILDER.define("Enabled", enabledByDefault), (Supplier<SchoolType>)BUILDER.defineEnum("School", (Enum)config.school), (Supplier<Integer>)BUILDER.define("MaxLevel", (Object)config.maxLevel), (Supplier<SpellRarity>)BUILDER.defineEnum("MinRarity", (Enum)config.minRarity), (Supplier<Double>)BUILDER.define("ManaCostMultiplier", (Object)1.0), (Supplier<Double>)BUILDER.define("SpellPowerMultiplier", (Object)1.0), (Supplier<Double>)BUILDER.define("CooldownInSeconds", (Object)config.cooldownInSeconds)));
        BUILDER.pop();
    }

    private static String createSpellConfigTitle(String str) {
        String[] words = str.split("[_| ]");
        for (int i = 0; i < words.length; ++i) {
            words[i] = words[i].substring(0, 1).toUpperCase() + words[i].substring(1);
        }
        return ((Stream)Arrays.stream(words).sequential()).collect(Collectors.joining("-"));
    }

    static {
        DEFAULT_CONFIG = new SpellConfigParameters(() -> true, () -> SchoolType.EVOCATION, () -> 10, () -> SpellRarity.COMMON, () -> 1.0, () -> 1.0, () -> 10.0);
        SPELL_CONFIGS = new HashMap<SpellType, SpellConfigParameters>();
        BUILDER.comment("Other Configuration");
        BUILDER.push("Misc");
        RARITY_CONFIG = BUILDER.worldRestart().comment(String.format("rarityConfig array values must sum to 1: [%s, %s, %s, %s, %s]. Default: [.3d, .25d, .2d, .15d, .1d]", new Object[]{SpellRarity.COMMON, SpellRarity.UNCOMMON, SpellRarity.RARE, SpellRarity.EPIC, SpellRarity.LEGENDARY})).defineList("rarityConfig", List.of(Double.valueOf(0.3), Double.valueOf(0.25), Double.valueOf(0.2), Double.valueOf(0.15), Double.valueOf(0.1)), x -> true);
        BUILDER.comment("Whether or not imbued weapons require mana to be casted. Default: true");
        SWORDS_CONSUME_MANA = BUILDER.worldRestart().define("swordsConsumeMana", true);
        BUILDER.comment("Whether or not players can harm their own magic summons. Default: false");
        CAN_ATTACK_OWN_SUMMONS = BUILDER.worldRestart().define("canAttackOwnSummons", false);
        BUILDER.comment("The maximum amount of times an applicable piece of equipment can be upgraded in the arcane anvil. Default: 3");
        MAX_UPGRADES = BUILDER.worldRestart().define("maxUpgrades", (Object)3);
        BUILDER.comment("From 0-1, the percent of max mana a player respawns with. Default: 0.0");
        MANA_SPAWN_PERCENT = BUILDER.worldRestart().define("manaSpawnPercent", (Object)0.0);
        BUILDER.pop();
        BUILDER.push("Upgrade Overrides");
        BUILDER.comment("Use these lists to change what items can interact with the Arcane Anvil's upgrade system. This can also be done via datapack.");
        BUILDER.comment("Upgrade Whitelist. Use an item's id to allow it to be upgraded, ex: \"minecraft:iron_sword\"");
        UPGRADE_WHITELIST = BUILDER.defineList("upgradeWhitelist", ArrayList::new, string -> true);
        BUILDER.comment("Upgrade Blacklist. Use an item's id to prevent it from being upgraded, ex: \"minecraft:iron_sword\"");
        UPGRADE_BLACKLIST = BUILDER.defineList("upgradeBlacklist", ArrayList::new, string -> true);
        BUILDER.pop();
        BUILDER.push("Imbue Overrides");
        BUILDER.comment("Use these lists to change what items can interact with the Arcane Anvil's imbue system.");
        BUILDER.comment("!THIS MAY HAVE UNINTENDED CONSEQUENCES!");
        BUILDER.comment("Upgrade Whitelist. Use an item's id to allow it to be imbued, ex: \"minecraft:iron_sword\"");
        IMBUE_WHITELIST = BUILDER.defineList("imbueWhitelist", ArrayList::new, string -> true);
        BUILDER.comment("Upgrade Blacklist. Use an item's id to prevent it from being imbued, ex: \"minecraft:iron_sword\"");
        IMBUE_BLACKLIST = BUILDER.defineList("imbueBlacklist", ArrayList::new, string -> true);
        BUILDER.pop();
        BUILDER.comment("Individual Spell Configuration");
        BUILDER.push("Spells");
        BUILDER.comment("Blood Spells");
        ServerConfigs.createSpellConfig(SpellType.BLOOD_SLASH_SPELL, BloodSlashSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.BLOOD_STEP_SPELL, BloodStepSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.HEARTSTOP_SPELL, HeartstopSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.RAISE_DEAD_SPELL, RaiseDeadSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.RAY_OF_SIPHONING_SPELL, RayOfSiphoningSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.WITHER_SKULL_SPELL, WitherSkullSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.BlOOD_NEEDLES_SPELL, BloodNeedlesSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.ACUPUNCTURE_SPELL, AcupunctureSpell.defaultConfig, true);
        BUILDER.comment("Ender Spells");
        ServerConfigs.createSpellConfig(SpellType.EVASION_SPELL, EvasionSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.MAGIC_ARROW_SPELL, MagicArrowSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.MAGIC_MISSILE_SPELL, MagicMissileSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.TELEPORT_SPELL, TeleportSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.COUNTERSPELL_SPELL, CounterspellSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.DRAGON_BREATH_SPELL, DragonBreathSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.STARFALL_SPELL, StarfallSpell.defaultConfig, true);
        BUILDER.comment("Evocation Spells");
        ServerConfigs.createSpellConfig(SpellType.CHAIN_CREEPER_SPELL, ChainCreeperSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.FANG_STRIKE_SPELL, FangStrikeSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.FANG_WARD_SPELL, FangWardSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.FIRECRACKER_SPELL, FirecrackerSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.INVISIBILITY_SPELL, InvisibilitySpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.LOB_CREEPER_SPELL, LobCreeperSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.SHIELD_SPELL, ShieldSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.SUMMON_HORSE_SPELL, SummonHorseSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.SUMMON_VEX_SPELL, SummonVexSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.SPECTRAL_HAMMER_SPELL, SpectralHammerSpell.defaultConfig, true);
        BUILDER.comment("Fire Spells");
        ServerConfigs.createSpellConfig(SpellType.BLAZE_STORM_SPELL, BlazeStormSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.BURNING_DASH_SPELL, BurningDashSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.FIREBALL_SPELL, FireballSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.FIREBOLT_SPELL, FireboltSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.FIRE_BREATH_SPELL, FireBreathSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.WALL_OF_FIRE_SPELL, WallOfFireSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.FIRE_BOMB_SPELL, FireBombSpell.defaultConfig, true);
        BUILDER.comment("Holy Spells");
        ServerConfigs.createSpellConfig(SpellType.ANGEL_WING_SPELL, AngelWingsSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.CLOUD_OF_REGENERATION_SPELL, CloudOfRegenerationSpell.defaultConfig, false);
        ServerConfigs.createSpellConfig(SpellType.GREATER_HEAL_SPELL, GreaterHealSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.HEAL_SPELL, HealSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.WISP_SPELL, WispSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.FORTIFY_SPELL, FortifySpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.BLESSING_OF_LIFE_SPELL, BlessingOfLifeSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.HEALING_CIRCLE_SPELL, HealingCircleSpell.defaultConfig, true);
        BUILDER.comment("Ice Spells");
        ServerConfigs.createSpellConfig(SpellType.CONE_OF_COLD_SPELL, ConeOfColdSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.FROST_STEP_SPELL, FrostStepSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.ICICLE_SPELL, IcicleSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.SUMMON_POLAR_BEAR_SPELL, SummonPolarBearSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.ICE_BLOCK_SPELL, IceBlockSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.FROSTBITE_SPELL, FrostbiteSpell.defaultConfig, false);
        BUILDER.comment("Lightning Spells");
        ServerConfigs.createSpellConfig(SpellType.ELECTROCUTE_SPELL, ElectrocuteSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.LIGHTNING_BOLT_SPELL, LightningBoltSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.LIGHTNING_LANCE_SPELL, LightningLanceSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.CHARGE_SPELL, ChargeSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.ASCENSION_SPELL, AscensionSpell.defaultConfig, true);
        BUILDER.comment("Void Spells");
        ServerConfigs.createSpellConfig(SpellType.ABYSSAL_SHROUD_SPELL, AbyssalShroudSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.VOID_TENTACLES_SPELL, VoidTentaclesSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.BLACK_HOLE_SPELL, BlackHoleSpell.defaultConfig, true);
        BUILDER.comment("Poison Spells");
        ServerConfigs.createSpellConfig(SpellType.POISON_ARROW_SPELL, PoisonArrowSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.POISON_SPLASH_SPELL, PoisonSplashSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.POISON_BREATH_SPELL, PoisonBreathSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.ACID_ORB_SPELL, AcidOrbSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.SPIDER_ASPECT_SPELL, SpiderAspectSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.BLIGHT_SPELL, BlightSpell.defaultConfig, true);
        ServerConfigs.createSpellConfig(SpellType.ROOT_SPELL, RootSpell.defaultConfig, true);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }

    public static class SpellConfigParameters {
        final Supplier<Boolean> ENABLED;
        final Supplier<SchoolType> SCHOOL;
        final Supplier<Integer> MAX_LEVEL;
        final Supplier<SpellRarity> MIN_RARITY;
        final Supplier<Double> M_MULT;
        final Supplier<Double> P_MULT;
        final Supplier<Double> CS;
        private SchoolType resolvedSchool = null;

        SpellConfigParameters(Supplier<Boolean> ENABLED, Supplier<SchoolType> SCHOOL, Supplier<Integer> MAX_LEVEL, Supplier<SpellRarity> MIN_RARITY, Supplier<Double> M_MULT, Supplier<Double> P_MULT, Supplier<Double> CS) {
            this.ENABLED = ENABLED;
            this.SCHOOL = SCHOOL;
            this.MAX_LEVEL = MAX_LEVEL;
            this.MIN_RARITY = MIN_RARITY;
            this.M_MULT = M_MULT;
            this.P_MULT = P_MULT;
            this.CS = CS;
        }

        public boolean enabled() {
            return this.ENABLED.get();
        }

        public int maxLevel() {
            return this.MAX_LEVEL.get();
        }

        public SpellRarity minRarity() {
            return this.MIN_RARITY.get();
        }

        public double powerMultiplier() {
            return this.P_MULT.get();
        }

        public double manaMultiplier() {
            return this.M_MULT.get();
        }

        public int cooldownInTicks() {
            return (int)(this.CS.get() * 20.0);
        }

        public SchoolType school() {
            return this.SCHOOL.get();
        }
    }
}

