/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import io.redspace.ironsspellbooks.capabilities.spell.SpellData;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.Component;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.server.command.EnumArgument;

public class CreateScrollCommand {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.irons_spellbooks.create_scroll.failed", new Object[0]));

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"createScroll").requires(p_138819_ -> p_138819_.m_6761_(2))).then(Commands.m_82129_((String)"spellType", (ArgumentType)EnumArgument.enumArgument(SpellType.class)).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(commandContext -> CreateScrollCommand.createScroll((CommandSourceStack)commandContext.getSource(), (SpellType)((Object)((Object)commandContext.getArgument("spellType", SpellType.class))), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"level"))))));
    }

    private static int createScroll(CommandSourceStack source, SpellType spellType, int spellLevel) throws CommandSyntaxException {
        if (spellLevel > spellType.getMaxLevel()) {
            throw new SimpleCommandExceptionType((Message)Component.translatable("commands.irons_spellbooks.create_spell.failed_max_level", new Object[]{spellType, spellType.getMaxLevel()})).create();
        }
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            ItemStack itemstack = new ItemStack((ItemLike)ItemRegistry.SCROLL.get());
            SpellData.setSpellData(itemstack, spellType, spellLevel);
            if (serverPlayer.m_150109_().m_36054_(itemstack)) {
                return 1;
            }
        }
        throw ERROR_FAILED.create();
    }
}

