/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.redspace.ironsspellbooks.capabilities.spell.SpellData;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.Component;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.server.command.EnumArgument;

public class CreateImbuedSwordCommand {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.irons_spellbooks.create_imbued_sword.failed", new Object[0]));
    private static final SimpleCommandExceptionType ERROR_FAILED_MAX_LEVEL = new SimpleCommandExceptionType((Message)Component.translatable("commands.irons_spellbooks.create_imbued_sword.failed_max_level", new Object[0]));
    private static final SuggestionProvider<CommandSourceStack> SWORD_SUGGESTIONS = (p_180253_, p_180254_) -> {
        Set resources = Registry.f_122827_.m_123024_().filter(k -> k instanceof SwordItem).map(arg_0 -> ((DefaultedRegistry)Registry.f_122827_).m_7981_(arg_0)).collect(Collectors.toSet());
        return SharedSuggestionProvider.m_82926_(resources, (SuggestionsBuilder)p_180254_);
    };

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"createImbuedSword").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).then(Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_120960_()).suggests(SWORD_SUGGESTIONS).then(Commands.m_82129_((String)"spellType", (ArgumentType)EnumArgument.enumArgument(SpellType.class)).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> CreateImbuedSwordCommand.createImbuedSword((CommandSourceStack)ctx.getSource(), (ItemInput)ctx.getArgument("item", ItemInput.class), (SpellType)((Object)((Object)ctx.getArgument("spellType", SpellType.class))), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"level")))))));
    }

    private static int createImbuedSword(CommandSourceStack source, ItemInput itemInput, SpellType spellType, int spellLevel) throws CommandSyntaxException {
        if (spellLevel > spellType.getMaxLevel()) {
            throw new SimpleCommandExceptionType((Message)Component.translatable("commands.irons_spellbooks.create_spell.failed_max_level", new Object[]{spellType, spellType.getMaxLevel()})).create();
        }
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            ItemStack itemstack = new ItemStack((ItemLike)itemInput.m_120979_());
            if (itemstack.m_41720_() instanceof SwordItem) {
                SpellData.setSpellData(itemstack, spellType, spellLevel);
                if (serverPlayer.m_150109_().m_36054_(itemstack)) {
                    return 1;
                }
            }
        }
        throw ERROR_FAILED.create();
    }
}

