/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.entity.mobs.debug_wizard.DebugWizard;
import io.redspace.ironsspellbooks.registries.EntityRegistry;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.Component;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.server.command.EnumArgument;

public class CreateDebugWizardCommand {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.irons_spellbooks.create_debug_wizard.failed", new Object[0]));
    private static final SimpleCommandExceptionType ERROR_FAILED_MAX_LEVEL = new SimpleCommandExceptionType((Message)Component.translatable("commands.irons_spellbooks.create_debug_wizard.failed_max_level", new Object[0]));

    public static void register(CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"createDebugWizard").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).then(Commands.m_82129_((String)"spellType", (ArgumentType)EnumArgument.enumArgument(SpellType.class)).then(Commands.m_82129_((String)"spellLevel", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"targetsPlayer", (ArgumentType)BoolArgumentType.bool()).then(Commands.m_82129_((String)"cancelAfterTicks", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> CreateDebugWizardCommand.createDebugWizard((CommandSourceStack)ctx.getSource(), (SpellType)((Object)((Object)ctx.getArgument("spellType", SpellType.class))), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"spellLevel"), BoolArgumentType.getBool((CommandContext)ctx, (String)"targetsPlayer"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"cancelAfterTicks"))))))));
    }

    private static int createDebugWizard(CommandSourceStack source, SpellType spellType, int spellLevel, boolean targetsPlayer, int cancelAfterTicks) throws CommandSyntaxException {
        if (spellLevel > spellType.getMaxLevel()) {
            throw new SimpleCommandExceptionType((Message)Component.translatable("commands.irons_spellbooks.create_spell.failed_max_level", new Object[]{spellType, spellType.getMaxLevel()})).create();
        }
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            DebugWizard debugWizard = new DebugWizard((EntityType<? extends AbstractSpellCastingMob>)((EntityType)EntityRegistry.DEBUG_WIZARD.get()), serverPlayer.f_19853_, spellType, spellLevel, targetsPlayer, cancelAfterTicks);
            debugWizard.m_146884_(serverPlayer.m_20182_());
            if (serverPlayer.f_19853_.m_7967_((Entity)debugWizard)) {
                return 1;
            }
        }
        throw ERROR_FAILED.create();
    }
}

