/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.capabilities.spellbook;

import io.redspace.ironsspellbooks.item.SpellBook;
import io.redspace.ironsspellbooks.item.UniqueSpellBook;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.Component;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.ArrayUtils;

public class SpellBookData {
    public static final String ISB_SPELLBOOK = "ISB_spellbook";
    public static final String SPELL_SLOTS = "spellSlots";
    public static final String ACTIVE_SPELL_INDEX = "activeSpellIndex";
    public static final String SPELLS = "spells";
    public static final String ID = "id";
    public static final String LEVEL = "level";
    public static final String SLOT = "slot";
    private AbstractSpell[] transcribedSpells;
    private int activeSpellIndex = -1;
    private int spellSlots;
    private int spellCount = 0;
    private boolean dirty = true;
    private List<Component> hoverText;

    public SpellBookData(CompoundTag tag) {
        this.loadFromNBT(tag);
    }

    public SpellBookData(int spellSlots) {
        this.spellSlots = spellSlots;
        this.transcribedSpells = new AbstractSpell[this.spellSlots];
    }

    public AbstractSpell getActiveSpell() {
        if (this.activeSpellIndex < 0) {
            return AbstractSpell.getSpell(SpellType.NONE_SPELL, 0);
        }
        AbstractSpell spell = this.transcribedSpells[this.activeSpellIndex];
        if (spell == null) {
            return AbstractSpell.getSpell(SpellType.NONE_SPELL, 0);
        }
        return this.transcribedSpells[this.activeSpellIndex];
    }

    public boolean setActiveSpellIndex(AbstractSpell spell, ItemStack stack) {
        int index = ArrayUtils.indexOf((Object[])this.transcribedSpells, (Object)spell);
        return this.setActiveSpellIndex(index, stack);
    }

    public boolean setActiveSpellIndex(int index, ItemStack stack) {
        if (index > -1 && index < this.transcribedSpells.length && this.transcribedSpells[index] != null) {
            this.activeSpellIndex = index;
            this.handleDirty(stack);
            return true;
        }
        return false;
    }

    public AbstractSpell[] getInscribedSpells() {
        AbstractSpell[] result = new AbstractSpell[this.spellSlots];
        System.arraycopy(this.transcribedSpells, 0, result, 0, this.transcribedSpells.length);
        return result;
    }

    public List<AbstractSpell> getActiveInscribedSpells() {
        return Arrays.stream(this.transcribedSpells).filter(Objects::nonNull).toList();
    }

    private void handleDirty(ItemStack stack) {
        if (stack != null) {
            SpellBookData.setSpellBookData(stack, this);
        }
    }

    public int getSpellSlots() {
        return this.spellSlots;
    }

    public int getActiveSpellIndex() {
        return this.activeSpellIndex;
    }

    public int getSpellCount() {
        return this.spellCount;
    }

    public AbstractSpell getSpell(int index) {
        return this.transcribedSpells[index];
    }

    public boolean addSpell(AbstractSpell spell, int index, ItemStack stack) {
        if (index > -1 && index < this.transcribedSpells.length && this.transcribedSpells[index] == null && Arrays.stream(this.transcribedSpells).noneMatch(s -> s != null && s.getSpellType() == spell.getSpellType())) {
            this.transcribedSpells[index] = spell;
            ++this.spellCount;
            if (this.spellCount == 1) {
                this.setActiveSpellIndex(index, null);
            }
            this.handleDirty(stack);
            return true;
        }
        return false;
    }

    public boolean addSpell(AbstractSpell spell, ItemStack stack) {
        int index = this.getNextSpellIndex();
        if (index > -1) {
            return this.addSpell(spell, index, stack);
        }
        return false;
    }

    private int getNextSpellIndex() {
        return ArrayUtils.indexOf((Object[])this.transcribedSpells, null);
    }

    public boolean replaceSpell(AbstractSpell oldSpell, AbstractSpell newSpell, ItemStack stack) {
        int index;
        if (oldSpell != null && newSpell != null && (index = ArrayUtils.indexOf((Object[])this.transcribedSpells, (Object)oldSpell)) > -1 && this.removeSpell(index, null)) {
            return this.addSpell(newSpell, index, stack);
        }
        return false;
    }

    public boolean replaceSpell(int index, AbstractSpell newSpell, ItemStack stack) {
        if (index > -1 && index < this.transcribedSpells.length) {
            return this.replaceSpell(this.transcribedSpells[index], newSpell, stack);
        }
        return false;
    }

    public boolean removeSpell(AbstractSpell spell, ItemStack stack) {
        return this.removeSpell(ArrayUtils.indexOf((Object[])this.transcribedSpells, (Object)spell), stack);
    }

    public boolean removeSpell(int index, ItemStack stack) {
        if (index > -1 && index < this.transcribedSpells.length && this.transcribedSpells[index] != null) {
            this.transcribedSpells[index] = null;
            --this.spellCount;
            if (this.spellCount == 0) {
                this.activeSpellIndex = -1;
            } else {
                for (int i = 0; i < this.transcribedSpells.length; ++i) {
                    if (this.transcribedSpells[i] == null) continue;
                    this.activeSpellIndex = i;
                    break;
                }
            }
            this.handleDirty(stack);
            return true;
        }
        return false;
    }

    public CompoundTag getNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_(SPELL_SLOTS, this.spellSlots);
        compound.m_128405_(ACTIVE_SPELL_INDEX, this.activeSpellIndex);
        ListTag listTagSpells = new ListTag();
        for (int i = 0; i < this.transcribedSpells.length; ++i) {
            AbstractSpell spell = this.transcribedSpells[i];
            if (spell == null) continue;
            CompoundTag ct = new CompoundTag();
            ct.m_128405_(ID, spell.getID());
            ct.m_128405_(LEVEL, spell.getLevel(null));
            ct.m_128405_(SLOT, i);
            listTagSpells.add((Object)ct);
        }
        compound.m_128365_(SPELLS, (Tag)listTagSpells);
        return compound;
    }

    public void loadFromNBT(CompoundTag compound) {
        this.spellSlots = compound.m_128451_(SPELL_SLOTS);
        this.transcribedSpells = new AbstractSpell[this.spellSlots];
        this.activeSpellIndex = compound.m_128451_(ACTIVE_SPELL_INDEX);
        ListTag listTagSpells = (ListTag)compound.m_128423_(SPELLS);
        this.spellCount = 0;
        if (listTagSpells != null) {
            listTagSpells.forEach(tag -> {
                AbstractSpell s;
                CompoundTag t = (CompoundTag)tag;
                int id = t.m_128451_(ID);
                int level = t.m_128451_(LEVEL);
                int index = t.m_128451_(SLOT);
                this.transcribedSpells[index] = s = AbstractSpell.getSpell(id, level);
                ++this.spellCount;
            });
        }
    }

    public static SpellBookData getSpellBookData(ItemStack stack) {
        if (stack == null) {
            return new SpellBookData(0);
        }
        CompoundTag tag = stack.m_41737_(ISB_SPELLBOOK);
        if (tag != null) {
            return new SpellBookData(tag);
        }
        Item item = stack.m_41720_();
        if (item instanceof SpellBook) {
            SpellBook spellBook = (SpellBook)item;
            SpellBookData spellBookData = new SpellBookData(spellBook.getSpellSlots());
            if (spellBook instanceof UniqueSpellBook) {
                UniqueSpellBook uniqueSpellBook = (UniqueSpellBook)spellBook;
                Arrays.stream(uniqueSpellBook.getSpells()).forEach(spell -> spellBookData.addSpell((AbstractSpell)spell, null));
            }
            SpellBookData.setSpellBookData(stack, spellBookData);
            return spellBookData;
        }
        return new SpellBookData(0);
    }

    public static void setSpellBookData(ItemStack stack, SpellBookData spellBookData) {
        if (spellBookData != null) {
            stack.m_41700_(ISB_SPELLBOOK, (Tag)spellBookData.getNBT());
        }
    }
}

