/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.capabilities.spell;

import io.redspace.ironsspellbooks.item.weapons.ExtendedSwordItem;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.SpellType;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SpellData {
    public static final String SPELL_ID = "spellId";
    public static final String LEVEL = "level";
    public static final String ISB_SPELL = "ISB_spell";
    public static final String SPELL_TYPE = "type";
    public static final String SPELL_LEVEL = "level";
    private MutableComponent displayName;
    private List<MutableComponent> hoverText;
    private AbstractSpell spell;
    private int spellId;
    private int spellLevel;

    public SpellData(SpellType spellType, int level) {
        this.spellId = spellType.getValue();
        this.spellLevel = level;
    }

    public static SpellData getSpellData(ItemStack stack) {
        CompoundTag tag = stack.m_41737_(ISB_SPELL);
        if (tag != null) {
            return new SpellData(SpellType.getTypeFromValue(tag.m_128451_(SPELL_TYPE)), tag.m_128451_("level"));
        }
        Item item = stack.m_41720_();
        if (item instanceof ExtendedSwordItem) {
            ExtendedSwordItem extendedSwordItem = (ExtendedSwordItem)item;
            SpellData.setSpellData(stack, extendedSwordItem.getImbuedSpell(), extendedSwordItem.getImbuedLevel());
            return new SpellData(extendedSwordItem.getImbuedSpell(), extendedSwordItem.getImbuedLevel());
        }
        return new SpellData(SpellType.NONE_SPELL, 0);
    }

    public static boolean hasSpellData(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41737_(ISB_SPELL);
        return tag != null;
    }

    public static void setSpellData(ItemStack stack, int spellTypeId, int spellLevel) {
        CompoundTag spellTag = new CompoundTag();
        spellTag.m_128405_(SPELL_TYPE, spellTypeId);
        spellTag.m_128405_("level", spellLevel);
        stack.m_41700_(ISB_SPELL, (Tag)spellTag);
    }

    public static void setSpellData(ItemStack stack, SpellType spellType, int spellLevel) {
        SpellData.setSpellData(stack, spellType.getValue(), spellLevel);
    }

    public static void setSpellData(ItemStack stack, AbstractSpell spell) {
        SpellData.setSpellData(stack, spell.getSpellType().getValue(), spell.getLevel(null));
    }

    public AbstractSpell getSpell() {
        if (this.spell == null) {
            this.spell = AbstractSpell.getSpell(this.spellId, this.spellLevel);
        }
        return this.spell;
    }

    public int getSpellId() {
        return this.spellId;
    }

    public int getLevel() {
        return this.spellLevel;
    }

    public Component getDisplayName() {
        if (this.displayName == null) {
            this.displayName = this.getSpell().getSpellType().getDisplayName().m_130946_(" ").m_7220_((Component)io.redspace.ironsspellbooks.util.Component.translatable(((Item)ItemRegistry.SCROLL.get()).m_5524_(), new Object[0]));
        }
        return this.displayName;
    }
}

