/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.capabilities.magic;

import io.redspace.ironsspellbooks.capabilities.magic.AbstractMagicData;
import io.redspace.ironsspellbooks.capabilities.magic.CastData;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerCooldowns;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicProvider;
import io.redspace.ironsspellbooks.capabilities.magic.SyncedSpellData;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.CastSource;
import io.redspace.ironsspellbooks.spells.CastType;
import io.redspace.ironsspellbooks.spells.SpellType;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class PlayerMagicData
extends AbstractMagicData {
    private boolean isMob = false;
    private ServerPlayer serverPlayer = null;
    public static final String MANA = "mana";
    public static final String COOLDOWNS = "cooldowns";
    private int mana;
    private SyncedSpellData syncedSpellData;
    private int castingSpellLevel = 0;
    private int castDuration = 0;
    private int castDurationRemaining = 0;
    private CastSource castSource;
    private CastType castType;
    @Nullable
    private CastData additionalCastData;
    private ItemStack castingItemStack = ItemStack.f_41583_;
    private final PlayerCooldowns playerCooldowns = new PlayerCooldowns();

    public PlayerMagicData(boolean isMob) {
        this.isMob = isMob;
    }

    public PlayerMagicData() {
        this(false);
    }

    public PlayerMagicData(ServerPlayer serverPlayer) {
        this(false);
        this.serverPlayer = serverPlayer;
    }

    public void setServerPlayer(ServerPlayer serverPlayer) {
        if (this.serverPlayer == null) {
            this.serverPlayer = serverPlayer;
        }
    }

    public int getMana() {
        return this.mana;
    }

    public void setMana(int mana) {
        this.mana = mana;
    }

    public void addMana(int mana) {
        this.mana += mana;
    }

    public SyncedSpellData getSyncedData() {
        if (this.syncedSpellData == null) {
            this.syncedSpellData = new SyncedSpellData((LivingEntity)this.serverPlayer);
        }
        return this.syncedSpellData;
    }

    public void setSyncedData(SyncedSpellData syncedSpellData) {
        this.syncedSpellData = syncedSpellData;
    }

    public void resetCastingState() {
        this.castingSpellLevel = 0;
        this.castDuration = 0;
        this.castDurationRemaining = 0;
        this.castSource = CastSource.NONE;
        this.castType = CastType.NONE;
        this.getSyncedData().setIsCasting(false, SpellType.NONE_SPELL.getValue(), 0);
        this.resetAdditionalCastData();
        if (this.serverPlayer != null) {
            this.serverPlayer.m_5810_();
        } else if (!this.isMob) {
            Minecraft.m_91087_().f_91074_.m_5810_();
        }
    }

    public void initiateCast(int spellId, int spellLevel, int castDuration, CastSource castSource) {
        this.castingSpellLevel = spellLevel;
        this.castDuration = castDuration;
        this.castDurationRemaining = castDuration;
        this.castSource = castSource;
        this.castType = AbstractSpell.getSpell(spellId, spellLevel).getCastType();
        this.syncedSpellData.setIsCasting(true, spellId, spellLevel);
    }

    public CastData getAdditionalCastData() {
        return this.additionalCastData;
    }

    public void setAdditionalCastData(CastData newCastData) {
        this.additionalCastData = newCastData;
    }

    public void resetAdditionalCastData() {
        if (this.additionalCastData != null) {
            this.additionalCastData.reset();
            this.additionalCastData = null;
        }
    }

    public boolean isCasting() {
        return this.getSyncedData().isCasting();
    }

    public int getCastingSpellId() {
        return this.getSyncedData().getCastingSpellId();
    }

    public AbstractSpell getCastingSpell() {
        return AbstractSpell.getSpell(this.getSyncedData().getCastingSpellId(), this.castingSpellLevel);
    }

    public int getCastingSpellLevel() {
        return this.castingSpellLevel;
    }

    public CastSource getCastSource() {
        if (this.castSource == null) {
            return CastSource.NONE;
        }
        return this.castSource;
    }

    public CastType getCastType() {
        return this.castType;
    }

    public float getCastCompletionPercent() {
        if (this.castDuration == 0) {
            return 1.0f;
        }
        return 1.0f - (float)this.castDurationRemaining / (float)this.castDuration;
    }

    public int getCastDurationRemaining() {
        return this.castDurationRemaining;
    }

    public int getCastDuration() {
        return this.castDuration;
    }

    public void handleCastDuration() {
        --this.castDurationRemaining;
        if (this.castDurationRemaining <= 0) {
            this.castDurationRemaining = 0;
        }
    }

    public void setPlayerCastingItem(ItemStack itemStack) {
        this.castingItemStack = itemStack;
    }

    public ItemStack getPlayerCastingItem() {
        return this.castingItemStack;
    }

    public PlayerCooldowns getPlayerCooldowns() {
        return this.playerCooldowns;
    }

    public static PlayerMagicData getPlayerMagicData(LivingEntity livingEntity) {
        if (livingEntity instanceof AbstractSpellCastingMob) {
            AbstractSpellCastingMob abstractSpellCastingMob = (AbstractSpellCastingMob)livingEntity;
            return abstractSpellCastingMob.getPlayerMagicData();
        }
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            LazyOptional capContainer = serverPlayer.getCapability(PlayerMagicProvider.PLAYER_MAGIC);
            if (capContainer.isPresent()) {
                Optional opt = capContainer.resolve();
                if (opt.isEmpty()) {
                    return new PlayerMagicData(serverPlayer);
                }
                PlayerMagicData pmd = (PlayerMagicData)opt.get();
                pmd.setServerPlayer(serverPlayer);
                return pmd;
            }
            return new PlayerMagicData(serverPlayer);
        }
        return new PlayerMagicData(null);
    }

    public void saveNBTData(CompoundTag compound) {
        compound.m_128405_(MANA, this.mana);
        if (this.playerCooldowns.hasCooldownsActive()) {
            ListTag listTag = new ListTag();
            this.playerCooldowns.saveNBTData(listTag);
            if (!listTag.isEmpty()) {
                compound.m_128365_(COOLDOWNS, (Tag)listTag);
            }
        }
        this.getSyncedData().saveNBTData(compound);
    }

    public void loadNBTData(CompoundTag compound) {
        this.mana = compound.m_128451_(MANA);
        ListTag listTag = (ListTag)compound.m_128423_(COOLDOWNS);
        if (listTag != null && !listTag.isEmpty()) {
            this.playerCooldowns.loadNBTData(listTag);
        }
        this.getSyncedData().loadNBTData(compound);
    }

    public String toString() {
        return String.format("isCasting:%s, spellID:%d, spellLevel:%s, duration:%s, durationRemaining:%s, source:%s, type:%s", new Object[]{this.getSyncedData().isCasting(), this.getSyncedData().getCastingSpellId(), this.castingSpellLevel, this.castDuration, this.castDurationRemaining, this.castSource, this.castType});
    }
}

