/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.capabilities.magic;

import com.google.common.collect.Maps;
import io.redspace.ironsspellbooks.capabilities.magic.CooldownInstance;
import io.redspace.ironsspellbooks.network.ClientboundSyncCooldowns;
import io.redspace.ironsspellbooks.setup.Messages;
import io.redspace.ironsspellbooks.spells.SpellType;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.server.level.ServerPlayer;

public class PlayerCooldowns {
    public static final String SPELL_ID = "sid";
    public static final String SPELL_COOLDOWN = "scd";
    public static final String COOLDOWN_REMAINING = "cdr";
    private final Map<SpellType, CooldownInstance> spellCooldowns;
    private int tickBuffer = 0;

    public PlayerCooldowns() {
        this(Maps.newEnumMap(SpellType.class));
    }

    public PlayerCooldowns(Map<SpellType, CooldownInstance> spellCooldowns) {
        this.spellCooldowns = spellCooldowns;
    }

    public void setTickBuffer(int tickBuffer) {
        this.tickBuffer = tickBuffer;
    }

    public void tick(int actualTicks) {
        this.spellCooldowns.forEach((spell, cooldown) -> {
            if (this.decrementCooldown((CooldownInstance)cooldown, actualTicks)) {
                this.spellCooldowns.remove(spell);
            }
        });
    }

    public boolean hasCooldownsActive() {
        return !this.spellCooldowns.isEmpty();
    }

    public Map<SpellType, CooldownInstance> getSpellCooldowns() {
        return this.spellCooldowns;
    }

    public void addCooldown(SpellType spell, int durationTicks) {
        this.spellCooldowns.put(spell, new CooldownInstance(durationTicks));
    }

    public void addCooldown(SpellType spell, int durationTicks, int remaining) {
        this.spellCooldowns.put(spell, new CooldownInstance(durationTicks, remaining));
    }

    public boolean isOnCooldown(SpellType spell) {
        return this.spellCooldowns.containsKey((Object)spell);
    }

    public float getCooldownPercent(SpellType spell) {
        return this.spellCooldowns.getOrDefault((Object)spell, new CooldownInstance(0)).getCooldownPercent();
    }

    private boolean decrementCooldown(CooldownInstance c, int amount) {
        c.decrementBy(amount);
        return c.getCooldownRemaining() <= this.tickBuffer;
    }

    public void syncToPlayer(ServerPlayer serverPlayer) {
        Messages.sendToPlayer(new ClientboundSyncCooldowns(this.spellCooldowns), serverPlayer);
    }

    public void saveNBTData(ListTag listTag) {
        this.spellCooldowns.forEach((spell, cooldown) -> {
            if (cooldown.getCooldownRemaining() > 0) {
                CompoundTag ct = new CompoundTag();
                ct.m_128405_(SPELL_ID, spell.getValue());
                ct.m_128405_(SPELL_COOLDOWN, cooldown.getSpellCooldown());
                ct.m_128405_(COOLDOWN_REMAINING, cooldown.getCooldownRemaining());
                listTag.add((Object)ct);
            }
        });
    }

    public void loadNBTData(ListTag listTag) {
        if (listTag != null) {
            listTag.forEach(tag -> {
                CompoundTag t = (CompoundTag)tag;
                SpellType spellType = SpellType.values()[t.m_128451_(SPELL_ID)];
                int spellCooldown = t.m_128451_(SPELL_COOLDOWN);
                int cooldownRemaining = t.m_128451_(COOLDOWN_REMAINING);
                this.spellCooldowns.put(spellType, new CooldownInstance(spellCooldown, cooldownRemaining));
            });
        }
    }
}

