/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.capabilities.magic;

import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.item.Scroll;
import io.redspace.ironsspellbooks.network.ClientboundSyncCooldown;
import io.redspace.ironsspellbooks.network.ClientboundSyncMana;
import io.redspace.ironsspellbooks.registries.AttributeRegistry;
import io.redspace.ironsspellbooks.setup.Messages;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.CastSource;
import io.redspace.ironsspellbooks.spells.CastType;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.Utils;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class MagicManager {
    public static final int MANA_REGEN_TICKS = 10;
    public static final int CONTINUOUS_CAST_TICK_INTERVAL = 10;
    private static MagicManager magicManager = null;

    @Nonnull
    public static MagicManager get(Level level) {
        if (level.f_46443_) {
            throw new RuntimeException("Don't access the ManaManager client-side!");
        }
        if (magicManager == null) {
            magicManager = new MagicManager();
        }
        return magicManager;
    }

    public void setPlayerCurrentMana(ServerPlayer serverPlayer, int newManaValue) {
        PlayerMagicData playerMagicData = PlayerMagicData.getPlayerMagicData((LivingEntity)serverPlayer);
        playerMagicData.setMana(newManaValue);
    }

    public void regenPlayerMana(ServerPlayer serverPlayer, PlayerMagicData playerMagicData) {
        int playerMaxMana = (int)serverPlayer.m_21133_((Attribute)AttributeRegistry.MAX_MANA.get());
        int increment = Math.round(Math.max((float)playerMaxMana * 0.01f, 1.0f));
        if (playerMagicData.getMana() != playerMaxMana) {
            if (playerMagicData.getMana() + increment < playerMaxMana) {
                playerMagicData.addMana(increment);
            } else {
                playerMagicData.setMana(playerMaxMana);
            }
        }
    }

    public void tick(Level level) {
        boolean doManaRegen = level.m_142572_().m_129921_() % 10 == 0;
        level.m_6907_().forEach(player -> {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PlayerMagicData playerMagicData = PlayerMagicData.getPlayerMagicData((LivingEntity)serverPlayer);
                playerMagicData.getPlayerCooldowns().tick(1);
                if (playerMagicData.isCasting()) {
                    playerMagicData.handleCastDuration();
                    AbstractSpell spell = AbstractSpell.getSpell(playerMagicData.getCastingSpellId(), playerMagicData.getCastingSpellLevel());
                    if (spell.getCastType() == CastType.LONG || spell.getCastType() == CastType.CHARGE && !serverPlayer.m_6117_()) {
                        if (playerMagicData.getCastDurationRemaining() <= 0) {
                            spell.castSpell(serverPlayer.f_19853_, serverPlayer, playerMagicData.getCastSource(), true);
                            spell.onServerCastComplete(serverPlayer.f_19853_, (LivingEntity)serverPlayer, playerMagicData, false);
                            Scroll.attemptRemoveScrollAfterCast(serverPlayer);
                        }
                    } else if (spell.getCastType() == CastType.CONTINUOUS && (playerMagicData.getCastDurationRemaining() + 1) % 10 == 0) {
                        if (playerMagicData.getCastDurationRemaining() < 10 || playerMagicData.getCastSource().consumesMana() && playerMagicData.getMana() - spell.getManaCost() * 2 < 0) {
                            spell.castSpell(serverPlayer.f_19853_, serverPlayer, playerMagicData.getCastSource(), true);
                            if (playerMagicData.getCastSource() == CastSource.SCROLL) {
                                Scroll.attemptRemoveScrollAfterCast(serverPlayer);
                            }
                            spell.onServerCastComplete(serverPlayer.f_19853_, (LivingEntity)serverPlayer, playerMagicData, false);
                        } else {
                            spell.castSpell(serverPlayer.f_19853_, serverPlayer, playerMagicData.getCastSource(), false);
                        }
                    }
                    if (playerMagicData.isCasting()) {
                        spell.onServerCastTick(serverPlayer.f_19853_, (LivingEntity)serverPlayer, playerMagicData);
                    }
                }
                if (doManaRegen) {
                    this.regenPlayerMana(serverPlayer, playerMagicData);
                    Messages.sendToPlayer(new ClientboundSyncMana(playerMagicData), serverPlayer);
                }
            }
        });
    }

    public void addCooldown(ServerPlayer serverPlayer, SpellType spellType, CastSource castSource) {
        if (castSource == CastSource.SCROLL) {
            return;
        }
        int effectiveCooldown = MagicManager.getEffectiveSpellCooldown(spellType, (Player)serverPlayer, castSource);
        PlayerMagicData.getPlayerMagicData((LivingEntity)serverPlayer).getPlayerCooldowns().addCooldown(spellType, effectiveCooldown);
        Messages.sendToPlayer(new ClientboundSyncCooldown(spellType.getValue(), effectiveCooldown), serverPlayer);
    }

    public static int getEffectiveSpellCooldown(SpellType spellType, Player player, CastSource castSource) {
        double playerCooldownModifier = player == null ? 0.0 : player.m_21133_((Attribute)AttributeRegistry.COOLDOWN_REDUCTION.get());
        int itemCoolDownModifer = 1;
        if (castSource == CastSource.SWORD) {
            itemCoolDownModifer = 2;
        }
        return (int)((double)AbstractSpell.getSpell(spellType, 1).getSpellCooldown() * (2.0 - Utils.softCapFormula(playerCooldownModifier)) * (double)itemCoolDownModifer);
    }

    public static void spawnParticles(Level level, ParticleOptions particle, double x, double y, double z, int count, double deltaX, double deltaY, double deltaZ, double speed, boolean force) {
        level.m_142572_().m_6846_().m_11314_().forEach(player -> ((ServerLevel)level).m_8624_(player, particle, force, x, y, z, count, deltaX, deltaY, deltaZ, speed));
    }
}

