/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.mixin.lightsource;

import dev.lambdaurora.lambdynlights.DynamicLightSource;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.api.DynamicLightHandlers;
import dev.lambdaurora.lambdynlights.config.DynamicLightsConfig;
import dev.lambdaurora.lambdynlights.config.QualityMode;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockEntity.class})
public abstract class BlockEntityMixin
implements DynamicLightSource {
    @Final
    @Shadow
    protected BlockPos f_58858_;
    @Shadow
    @Nullable
    protected Level f_58857_;
    @Shadow
    protected boolean f_58859_;
    @Unique
    private int luminance = 0;
    @Unique
    private int lastLuminance = 0;
    @Unique
    private long lastUpdate = 0L;
    @Unique
    private final LongOpenHashSet lambdynlights$trackedLitChunkPos = new LongOpenHashSet();
    private static long lambdynlights_lastUpdate = 0L;

    @Override
    public double tdv$getDynamicLightX() {
        return (double)this.f_58858_.m_123341_() + 0.5;
    }

    @Override
    public double tdv$getDynamicLightY() {
        return (double)this.f_58858_.m_123342_() + 0.5;
    }

    @Override
    public double tdv$getDynamicLightZ() {
        return (double)this.f_58858_.m_123343_() + 0.5;
    }

    @Override
    public Level tdv$getDynamicLightWorld() {
        return this.f_58857_;
    }

    @Inject(method={"setRemoved"}, at={@At(value="TAIL")})
    private void onRemoved(CallbackInfo ci) {
        this.tdv$setDynamicLightEnabled(false);
    }

    @Override
    public void tdv$resetDynamicLight() {
        this.lastLuminance = 0;
    }

    @Override
    public void tdv$dynamicLightTick() {
        if (this.f_58857_ == null || !this.f_58857_.m_5776_()) {
            return;
        }
        if (!this.f_58859_) {
            this.luminance = DynamicLightHandlers.getLuminanceFrom((BlockEntity)this);
            LambDynLights.updateTracking(this);
            if (!this.tdv$isDynamicLightEnabled()) {
                this.lastLuminance = 0;
            }
        }
    }

    @Override
    public int tdv$getLuminance() {
        return this.luminance;
    }

    @Override
    public boolean tdv$shouldUpdateDynamicLight() {
        QualityMode mode = (QualityMode)((Object)DynamicLightsConfig.Quality.get());
        if (Objects.equals((Object)mode, (Object)QualityMode.OFF)) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (Objects.equals((Object)mode, (Object)QualityMode.SLOW) && currentTime < lambdynlights_lastUpdate + 500L) {
            return false;
        }
        if (Objects.equals((Object)mode, (Object)QualityMode.FAST) && currentTime < lambdynlights_lastUpdate + 200L) {
            return false;
        }
        lambdynlights_lastUpdate = currentTime;
        return true;
    }

    @Override
    public boolean tdv$lambdynlights$updateDynamicLight(@NotNull LevelRenderer renderer) {
        if (!this.tdv$shouldUpdateDynamicLight()) {
            return false;
        }
        int luminance = this.tdv$getLuminance();
        if (luminance != this.lastLuminance) {
            this.lastLuminance = luminance;
            if (this.lambdynlights$trackedLitChunkPos.isEmpty()) {
                BlockPos.MutableBlockPos chunkPos = new BlockPos.MutableBlockPos(Mth.m_14042_((int)this.f_58858_.m_123341_(), (int)16), Mth.m_14042_((int)this.f_58858_.m_123342_(), (int)16), Mth.m_14042_((int)this.f_58858_.m_123343_(), (int)16));
                LambDynLights.updateTrackedChunks((BlockPos)chunkPos, null, this.lambdynlights$trackedLitChunkPos);
                Direction directionX = (this.f_58858_.m_123341_() & 0xF) >= 8 ? Direction.EAST : Direction.WEST;
                Direction directionY = (this.f_58858_.m_123342_() & 0xF) >= 8 ? Direction.UP : Direction.DOWN;
                Direction directionZ = (this.f_58858_.m_123343_() & 0xF) >= 8 ? Direction.SOUTH : Direction.NORTH;
                for (int i = 0; i < 7; ++i) {
                    if (i % 4 == 0) {
                        chunkPos.m_122173_(directionX);
                    } else if (i % 4 == 1) {
                        chunkPos.m_122173_(directionZ);
                    } else if (i % 4 == 2) {
                        chunkPos.m_122173_(directionX.m_122424_());
                    } else {
                        chunkPos.m_122173_(directionZ.m_122424_());
                        chunkPos.m_122173_(directionY);
                    }
                    LambDynLights.updateTrackedChunks((BlockPos)chunkPos, null, this.lambdynlights$trackedLitChunkPos);
                }
            }
            this.tdv$lambdynlights$scheduleTrackedChunksRebuild(renderer);
            return true;
        }
        return false;
    }

    @Override
    public void tdv$lambdynlights$scheduleTrackedChunksRebuild(@NotNull LevelRenderer renderer) {
        if (this.f_58857_ == Minecraft.m_91087_().f_91073_) {
            LongIterator longIterator = this.lambdynlights$trackedLitChunkPos.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                LambDynLights.scheduleChunkRebuild(renderer, pos);
            }
        }
    }
}

